/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.http.authc;

import com.stormpath.sdk.client.AuthenticationScheme;
import com.stormpath.sdk.impl.authc.credentials.ApiKeyCredentials;
import com.stormpath.sdk.impl.authc.credentials.ClientCredentials;
import com.stormpath.sdk.impl.http.authc.RequestAuthenticator;
import com.stormpath.sdk.impl.http.authc.RequestAuthenticatorFactory;
import com.stormpath.sdk.impl.http.authc.SAuthc1RequestAuthenticator;
import com.stormpath.sdk.impl.http.support.RequestAuthenticationException;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Classes;
import java.lang.reflect.Constructor;

public class DefaultRequestAuthenticatorFactory
implements RequestAuthenticatorFactory {
    @Override
    public RequestAuthenticator create(AuthenticationScheme scheme, ClientCredentials clientCredentials) {
        Assert.isInstanceOf(ApiKeyCredentials.class, (Object)clientCredentials, (String)"clientCredentials must be of type ApiKeyCredentials.");
        ApiKeyCredentials apiKeyCredentials = (ApiKeyCredentials)clientCredentials;
        if (scheme == null) {
            return new SAuthc1RequestAuthenticator(apiKeyCredentials);
        }
        try {
            Class requestAuthenticatorClass = Classes.forName((String)scheme.getRequestAuthenticatorClassName());
            Constructor ctor = Classes.getConstructor((Class)requestAuthenticatorClass, (Class[])new Class[]{ApiKeyCredentials.class});
            return (RequestAuthenticator)Classes.instantiate((Constructor)ctor, (Object[])new Object[]{apiKeyCredentials});
        }
        catch (RuntimeException ex) {
            throw new RequestAuthenticationException("There was an error instantiating " + scheme.getRequestAuthenticatorClassName());
        }
    }
}

