/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.http.authc;

import com.stormpath.sdk.impl.authc.credentials.ApiKeyCredentials;
import com.stormpath.sdk.impl.http.Request;
import com.stormpath.sdk.impl.http.authc.RequestAuthenticator;
import com.stormpath.sdk.impl.http.support.RequestAuthenticationException;
import com.stormpath.sdk.impl.util.Base64;
import com.stormpath.sdk.lang.Assert;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicRequestAuthenticator
implements RequestAuthenticator {
    private static final Logger log = LoggerFactory.getLogger(BasicRequestAuthenticator.class);
    public static final String STORMPATH_DATE_HEADER = "X-Stormpath-Date";
    public static final String AUTHENTICATION_SCHEME = "Basic";
    public static final String TIMESTAMP_FORMAT = "yyyyMMdd'T'HHmmss'Z'";
    public static final String TIME_ZONE = "UTC";
    private static final String NL = "\n";
    private final ApiKeyCredentials apiKeyCredentials;

    public BasicRequestAuthenticator(ApiKeyCredentials apiKeyCredentials) {
        Assert.notNull((Object)apiKeyCredentials, (String)"apiKeyCredentials must be not be null.");
        this.apiKeyCredentials = apiKeyCredentials;
    }

    @Override
    public void authenticate(Request request) throws RequestAuthenticationException {
        byte[] valueBytes;
        Date date = new Date();
        SimpleDateFormat timestampFormat = new SimpleDateFormat(TIMESTAMP_FORMAT);
        timestampFormat.setTimeZone(new SimpleTimeZone(0, TIME_ZONE));
        String timestamp = timestampFormat.format(date);
        request.getHeaders().set(STORMPATH_DATE_HEADER, timestamp);
        String authorizationHeader = this.apiKeyCredentials.getId() + ":" + this.apiKeyCredentials.getSecret();
        try {
            valueBytes = authorizationHeader.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RequestAuthenticationException("Unable to acquire UTF-8 bytes!");
        }
        authorizationHeader = Base64.encodeBase64String(valueBytes);
        request.getHeaders().set("Authorization", "Basic " + authorizationHeader);
    }
}

