/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.group;

import com.stormpath.sdk.account.Account;
import com.stormpath.sdk.account.AccountCriteria;
import com.stormpath.sdk.account.AccountList;
import com.stormpath.sdk.account.Accounts;
import com.stormpath.sdk.directory.AccountStoreVisitor;
import com.stormpath.sdk.directory.Directory;
import com.stormpath.sdk.group.Group;
import com.stormpath.sdk.group.GroupMembership;
import com.stormpath.sdk.group.GroupMembershipList;
import com.stormpath.sdk.group.GroupOptions;
import com.stormpath.sdk.group.GroupStatus;
import com.stormpath.sdk.impl.ds.InternalDataStore;
import com.stormpath.sdk.impl.group.DefaultGroupMembership;
import com.stormpath.sdk.impl.resource.AbstractExtendableInstanceResource;
import com.stormpath.sdk.impl.resource.CollectionReference;
import com.stormpath.sdk.impl.resource.Property;
import com.stormpath.sdk.impl.resource.ResourceReference;
import com.stormpath.sdk.impl.resource.StatusProperty;
import com.stormpath.sdk.impl.resource.StringProperty;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.query.Criteria;
import com.stormpath.sdk.query.Criterion;
import com.stormpath.sdk.query.Options;
import com.stormpath.sdk.resource.ResourceException;
import com.stormpath.sdk.tenant.Tenant;
import java.util.Map;

public class DefaultGroup
extends AbstractExtendableInstanceResource
implements Group {
    static final StringProperty NAME = new StringProperty("name");
    static final StringProperty DESCRIPTION = new StringProperty("description");
    static final StatusProperty<GroupStatus> STATUS = new StatusProperty<GroupStatus>(GroupStatus.class);
    static final ResourceReference<Directory> DIRECTORY = new ResourceReference<Directory>("directory", Directory.class);
    static final ResourceReference<Tenant> TENANT = new ResourceReference<Tenant>("tenant", Tenant.class);
    static final CollectionReference<AccountList, Account> ACCOUNTS = new CollectionReference<AccountList, Account>("accounts", AccountList.class, Account.class);
    static final CollectionReference<GroupMembershipList, GroupMembership> ACCOUNT_MEMBERSHIPS = new CollectionReference<GroupMembershipList, GroupMembership>("accountMemberships", GroupMembershipList.class, GroupMembership.class);
    static final Map<String, Property> PROPERTY_DESCRIPTORS = DefaultGroup.createPropertyDescriptorMap(NAME, DESCRIPTION, STATUS, CUSTOM_DATA, DIRECTORY, TENANT, ACCOUNTS, ACCOUNT_MEMBERSHIPS);

    public DefaultGroup(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultGroup(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public String getName() {
        return this.getString(NAME);
    }

    public Group setName(String name) {
        this.setProperty(NAME, (Object)name);
        return this;
    }

    public String getDescription() {
        return this.getString(DESCRIPTION);
    }

    public Group setDescription(String description) {
        this.setProperty(DESCRIPTION, (Object)description);
        return this;
    }

    public GroupStatus getStatus() {
        String value = this.getStringProperty(STATUS.getName());
        if (value == null) {
            return null;
        }
        return GroupStatus.valueOf((String)value.toUpperCase());
    }

    public Group setStatus(GroupStatus status) {
        this.setProperty(STATUS, (Object)status.name());
        return this;
    }

    public Tenant getTenant() {
        return this.getResourceProperty(TENANT);
    }

    public Directory getDirectory() {
        return this.getResourceProperty(DIRECTORY);
    }

    public AccountList getAccounts() {
        return (AccountList)this.getResourceProperty(ACCOUNTS);
    }

    public AccountList getAccounts(Map<String, Object> queryParams) {
        AccountList list = this.getAccounts();
        return this.getDataStore().getResource(list.getHref(), AccountList.class, queryParams);
    }

    public AccountList getAccounts(AccountCriteria criteria) {
        AccountList list = this.getAccounts();
        return this.getDataStore().getResource(list.getHref(), AccountList.class, (Criteria)criteria);
    }

    public GroupMembershipList getAccountMemberships() {
        return (GroupMembershipList)this.getResourceProperty(ACCOUNT_MEMBERSHIPS);
    }

    public GroupMembership addAccount(Account account) {
        return DefaultGroupMembership.create(account, this, this.getDataStore());
    }

    public GroupMembership addAccount(String hrefOrEmailOrUsername) {
        Assert.hasText((String)hrefOrEmailOrUsername, (String)"hrefOrEmailOrUsername cannot be null or empty");
        Account account = this.findAccount(hrefOrEmailOrUsername);
        if (account != null) {
            return DefaultGroupMembership.create(account, this, this.getDataStore());
        }
        throw new IllegalStateException("No matching account for hrefOrEmailOrUsername was found.");
    }

    private Account findAccount(String hrefOrEmailOrUsername) {
        AccountList accounts;
        Account account = null;
        String[] splitHrefOrEmailOrName = hrefOrEmailOrUsername.split("/");
        Directory directory = this.getDirectory();
        if (splitHrefOrEmailOrName.length > 4) {
            try {
                account = (Account)this.getDataStore().getResource(hrefOrEmailOrUsername, Account.class);
                if (account != null && account.getDirectory().getHref().equals(directory.getHref())) {
                    return account;
                }
            }
            catch (ResourceException resourceException) {
                // empty catch block
            }
        }
        if ((accounts = directory.getAccounts(Accounts.where((Criterion)Accounts.username().eqIgnoreCase(hrefOrEmailOrUsername)))).iterator().hasNext()) {
            account = (Account)accounts.iterator().next();
        } else {
            accounts = directory.getAccounts(Accounts.where((Criterion)Accounts.email().eqIgnoreCase(hrefOrEmailOrUsername)));
            if (accounts.iterator().hasNext()) {
                account = (Account)accounts.iterator().next();
            }
        }
        return account;
    }

    public Group removeAccount(Account account) {
        Assert.notNull((Object)account, (String)"account cannot be null");
        GroupMembership groupMembership = null;
        for (GroupMembership accountGroupMembership : this.getAccountMemberships()) {
            if (!accountGroupMembership.getAccount().getHref().equals(account.getHref())) continue;
            groupMembership = accountGroupMembership;
            break;
        }
        if (groupMembership == null) {
            throw new IllegalStateException("The specified account does not belong to this Group.");
        }
        groupMembership.delete();
        return this;
    }

    public Group removeAccount(String hrefOrEmailOrUsername) {
        Assert.hasText((String)hrefOrEmailOrUsername, (String)"hrefOrEmailOrUsername cannot be null or empty");
        GroupMembership groupMembership = null;
        for (GroupMembership aGroupMembership : this.getAccountMemberships()) {
            if (!aGroupMembership.getAccount().getHref().equals(hrefOrEmailOrUsername) && !aGroupMembership.getAccount().getEmail().equals(hrefOrEmailOrUsername) && !aGroupMembership.getAccount().getUsername().equals(hrefOrEmailOrUsername)) continue;
            groupMembership = aGroupMembership;
            break;
        }
        if (groupMembership == null) {
            throw new IllegalStateException("The specified account does not belong to this Group.");
        }
        groupMembership.delete();
        return this;
    }

    public void delete() {
        this.getDataStore().delete(this);
    }

    public void accept(AccountStoreVisitor visitor) {
        visitor.visit((Group)this);
    }

    public Group saveWithResponseOptions(GroupOptions groupOptions) {
        Assert.notNull((Object)groupOptions, (String)"groupOptions can't be null.");
        this.applyCustomDataUpdatesIfNecessary();
        this.getDataStore().save(this, (Options)groupOptions);
        return this;
    }
}

