/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.error;

import com.stormpath.sdk.error.Error;
import com.stormpath.sdk.impl.error.DefaultError;
import com.stormpath.sdk.lang.Assert;
import java.util.HashMap;
import java.util.Map;

public class DefaultErrorBuilder {
    private final Map<String, Object> errorProperties;

    public DefaultErrorBuilder(Integer status) {
        Assert.notNull((Object)status, (String)"status cannot be null.");
        this.errorProperties = new HashMap<String, Object>();
        this.errorProperties.put(DefaultError.STATUS.getName(), status);
    }

    public static DefaultErrorBuilder status(Integer status) {
        return new DefaultErrorBuilder(status);
    }

    public DefaultErrorBuilder code(Integer code) {
        this.errorProperties.put(DefaultError.CODE.getName(), code);
        return this;
    }

    public DefaultErrorBuilder message(String message) {
        this.errorProperties.put(DefaultError.MESSAGE.getName(), message);
        return this;
    }

    public DefaultErrorBuilder developerMessage(String developerMessage) {
        this.errorProperties.put(DefaultError.DEV_MESSAGE.getName(), developerMessage);
        return this;
    }

    public DefaultErrorBuilder moreInfo(String moreInfo) {
        this.errorProperties.put(DefaultError.MORE_INFO.getName(), moreInfo);
        return this;
    }

    public DefaultErrorBuilder requestId(String requestId) {
        this.errorProperties.put(DefaultError.REQUEST_ID.getName(), requestId);
        return this;
    }

    public Error build() {
        for (Object value : this.errorProperties.values()) {
            Assert.notNull((Object)value);
        }
        return new DefaultError(this.errorProperties);
    }
}

