/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.ds.api;

import com.stormpath.sdk.api.ApiKey;
import com.stormpath.sdk.api.ApiKeyList;
import com.stormpath.sdk.impl.api.ApiKeyParameter;
import com.stormpath.sdk.impl.api.DefaultApiKey;
import com.stormpath.sdk.impl.api.DefaultApiKeyList;
import com.stormpath.sdk.impl.authc.credentials.ApiKeyCredentials;
import com.stormpath.sdk.impl.ds.DefaultResourceDataResult;
import com.stormpath.sdk.impl.ds.Filter;
import com.stormpath.sdk.impl.ds.FilterChain;
import com.stormpath.sdk.impl.ds.ResourceAction;
import com.stormpath.sdk.impl.ds.ResourceDataRequest;
import com.stormpath.sdk.impl.ds.ResourceDataResult;
import com.stormpath.sdk.impl.security.ApiKeySecretEncryptionService;
import com.stormpath.sdk.impl.security.EncryptionService;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.resource.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class DecryptApiKeySecretFilter
implements Filter {
    private static String ENCRYPTION_KEY_SALT = ApiKeyParameter.ENCRYPTION_KEY_SALT.getName();
    private static String ENCRYPTION_KEY_SIZE = ApiKeyParameter.ENCRYPTION_KEY_SIZE.getName();
    private static String ENCRYPTION_KEY_ITERATIONS = ApiKeyParameter.ENCRYPTION_KEY_ITERATIONS.getName();
    private static String ENCRYPTION_METADATA = ApiKeyParameter.ENCRYPTION_METADATA.getName();
    private final ApiKeyCredentials apiKeyCredentials;
    private final String SECRET_PROPERTY_NAME = DefaultApiKey.SECRET.getName();

    public DecryptApiKeySecretFilter(ApiKeyCredentials apiKeyCredentials) {
        Assert.notNull((Object)apiKeyCredentials);
        this.apiKeyCredentials = apiKeyCredentials;
    }

    @Override
    public ResourceDataResult filter(ResourceDataRequest request, FilterChain chain) {
        ResourceDataResult result = chain.filter(request);
        if (request.getAction() == ResourceAction.DELETE) {
            return result;
        }
        Class<? extends Resource> clazz = result.getResourceClass();
        if (!ApiKey.class.isAssignableFrom(clazz) && !ApiKeyList.class.isAssignableFrom(clazz)) {
            return result;
        }
        Map<String, Object> data = result.getData();
        if (DefaultApiKeyList.isCollectionResource(data)) {
            Collection items = (Collection)data.get("items");
            if (items.isEmpty()) {
                return result;
            }
            ArrayList<Map<String, Object>> clonedItems = new ArrayList<Map<String, Object>>(items.size());
            for (Map item : items) {
                clonedItems.add(this.clone(item));
            }
            data.put("items", clonedItems);
            return result;
        }
        return new DefaultResourceDataResult(result.getAction(), result.getUri(), clazz, this.clone(data));
    }

    private Map<String, Object> clone(Map<String, Object> input) {
        if (!input.containsKey(ENCRYPTION_METADATA)) {
            return input;
        }
        Map metadata = (Map)input.get(ENCRYPTION_METADATA);
        byte[] base64Salt = ((String)metadata.get(ENCRYPTION_KEY_SALT)).getBytes();
        Integer iterations = (Integer)metadata.get(ENCRYPTION_KEY_ITERATIONS);
        Integer size = (Integer)metadata.get(ENCRYPTION_KEY_SIZE);
        EncryptionService service = new ApiKeySecretEncryptionService.Builder().setPassword(this.apiKeyCredentials.getSecret().toCharArray()).setKeySize(size).setIterations(iterations).setBase64Salt(base64Salt).build();
        String encryptedSecret = (String)input.get(this.SECRET_PROPERTY_NAME);
        LinkedHashMap<String, Object> clonedData = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : input.entrySet()) {
            String key = entry.getKey();
            if (key.equals(ENCRYPTION_METADATA)) continue;
            if (key.equals(this.SECRET_PROPERTY_NAME)) {
                clonedData.put(key, service.decryptBase64String(encryptedSecret));
                continue;
            }
            clonedData.put(key, entry.getValue());
        }
        return clonedData;
    }
}

