/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.ds;

import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Collections;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Enlistment
implements Map<String, Object> {
    private static final Logger log = LoggerFactory.getLogger(Enlistment.class);
    protected final Map<String, Object> backingMap;
    protected final Lock readLock;
    protected final Lock writeLock;

    public Enlistment(Map<String, Object> map) {
        ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
        this.readLock = rwl.readLock();
        this.writeLock = rwl.writeLock();
        this.backingMap = new LinkedHashMap<String, Object>();
        this.setProperties(map);
    }

    public final void setProperties(Map<String, Object> properties) {
        if (properties != null) {
            this.writeLock.lock();
            try {
                this.backingMap.clear();
                this.backingMap.putAll(properties);
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    @Override
    public int hashCode() {
        this.readLock.lock();
        try {
            int n = this.backingMap.isEmpty() ? 0 : this.backingMap.hashCode();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public int size() {
        this.readLock.lock();
        try {
            int n = this.backingMap.size();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        this.readLock.lock();
        try {
            boolean bl = this.backingMap.isEmpty();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean containsKey(Object key) {
        Assert.isInstanceOf(String.class, (Object)key);
        this.readLock.lock();
        try {
            boolean bl = this.backingMap.containsKey(key);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean containsValue(Object value) {
        this.readLock.lock();
        try {
            boolean bl = this.backingMap.containsValue(value);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Object get(Object key) {
        Assert.isInstanceOf(String.class, (Object)key);
        this.readLock.lock();
        try {
            Object object = this.backingMap.get(key);
            return object;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object put(String key, Object value) {
        Object previous;
        this.writeLock.lock();
        try {
            previous = this.backingMap.put(key, value);
        }
        finally {
            this.writeLock.unlock();
        }
        return previous;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object remove(Object key) {
        Assert.isInstanceOf(String.class, (Object)key);
        this.writeLock.lock();
        try {
            Object object;
            Object object2 = object = this.backingMap.remove(key);
            return object2;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        if (Collections.isEmpty(m)) {
            return;
        }
        this.writeLock.lock();
        try {
            this.backingMap.putAll(m);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void clear() {
        this.writeLock.lock();
        try {
            this.backingMap.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public Set<String> keySet() {
        this.readLock.lock();
        try {
            Set<String> keys = this.backingMap.keySet();
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(keys);
            return linkedHashSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Collection<Object> values() {
        this.readLock.lock();
        try {
            Collection<Object> collection = this.backingMap.values();
            return collection;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        this.readLock.lock();
        try {
            Set<Map.Entry<String, Object>> set = this.backingMap.entrySet();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object o) {
        if (o instanceof Map && !(o instanceof Enlistment) && ((String)((Map)o).get("href")).contains("/apiKeys/")) {
            return o.equals(this);
        }
        if (!(o instanceof Enlistment)) {
            return false;
        }
        Enlistment other = (Enlistment)o;
        this.readLock.lock();
        try {
            other.readLock.lock();
            try {
                boolean bl = this.backingMap.equals(other);
                other.readLock.unlock();
                return bl;
            }
            catch (Throwable throwable) {
                other.readLock.unlock();
                throw throwable;
            }
        }
        finally {
            this.readLock.unlock();
        }
    }
}

