/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.ds;

import com.stormpath.sdk.api.ApiKey;
import com.stormpath.sdk.cache.CacheManager;
import com.stormpath.sdk.error.Error;
import com.stormpath.sdk.http.HttpMethod;
import com.stormpath.sdk.impl.authc.credentials.ApiKeyCredentials;
import com.stormpath.sdk.impl.authc.credentials.ClientCredentials;
import com.stormpath.sdk.impl.cache.DisabledCacheManager;
import com.stormpath.sdk.impl.ds.DefaultCacheRegionNameResolver;
import com.stormpath.sdk.impl.ds.DefaultFilterChain;
import com.stormpath.sdk.impl.ds.DefaultResourceConverter;
import com.stormpath.sdk.impl.ds.DefaultResourceDataRequest;
import com.stormpath.sdk.impl.ds.DefaultResourceDataResult;
import com.stormpath.sdk.impl.ds.DefaultResourceFactory;
import com.stormpath.sdk.impl.ds.EnlistmentFilter;
import com.stormpath.sdk.impl.ds.Filter;
import com.stormpath.sdk.impl.ds.FilterChain;
import com.stormpath.sdk.impl.ds.InternalDataStore;
import com.stormpath.sdk.impl.ds.JacksonMapMarshaller;
import com.stormpath.sdk.impl.ds.MapMarshaller;
import com.stormpath.sdk.impl.ds.ProviderAccountResultFilter;
import com.stormpath.sdk.impl.ds.ResourceAction;
import com.stormpath.sdk.impl.ds.ResourceConverter;
import com.stormpath.sdk.impl.ds.ResourceDataRequest;
import com.stormpath.sdk.impl.ds.ResourceDataResult;
import com.stormpath.sdk.impl.ds.ResourceFactory;
import com.stormpath.sdk.impl.ds.api.ApiKeyQueryFilter;
import com.stormpath.sdk.impl.ds.api.DecryptApiKeySecretFilter;
import com.stormpath.sdk.impl.ds.cache.CacheResolver;
import com.stormpath.sdk.impl.ds.cache.DefaultCacheResolver;
import com.stormpath.sdk.impl.ds.cache.ReadCacheFilter;
import com.stormpath.sdk.impl.ds.cache.WriteCacheFilter;
import com.stormpath.sdk.impl.error.DefaultError;
import com.stormpath.sdk.impl.http.CanonicalUri;
import com.stormpath.sdk.impl.http.HttpHeaders;
import com.stormpath.sdk.impl.http.HttpHeadersHolder;
import com.stormpath.sdk.impl.http.MediaType;
import com.stormpath.sdk.impl.http.QueryString;
import com.stormpath.sdk.impl.http.QueryStringFactory;
import com.stormpath.sdk.impl.http.Request;
import com.stormpath.sdk.impl.http.RequestExecutor;
import com.stormpath.sdk.impl.http.Response;
import com.stormpath.sdk.impl.http.support.DefaultCanonicalUri;
import com.stormpath.sdk.impl.http.support.DefaultRequest;
import com.stormpath.sdk.impl.http.support.UserAgent;
import com.stormpath.sdk.impl.query.DefaultCriteria;
import com.stormpath.sdk.impl.query.DefaultOptions;
import com.stormpath.sdk.impl.resource.AbstractResource;
import com.stormpath.sdk.impl.resource.ReferenceFactory;
import com.stormpath.sdk.impl.util.StringInputStream;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Collections;
import com.stormpath.sdk.lang.Strings;
import com.stormpath.sdk.query.Criteria;
import com.stormpath.sdk.query.Options;
import com.stormpath.sdk.resource.CollectionResource;
import com.stormpath.sdk.resource.Resource;
import com.stormpath.sdk.resource.ResourceException;
import com.stormpath.sdk.resource.Saveable;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDataStore
implements InternalDataStore {
    private static final Logger log = LoggerFactory.getLogger(DefaultDataStore.class);
    public static final String DEFAULT_SERVER_HOST = "api.stormpath.com";
    public static final int DEFAULT_API_VERSION = 1;
    private static final String APPEND_PARAM_CHAR = "&";
    public static final String DEFAULT_CRITERIA_MSG = "The " + DefaultDataStore.class.getName() + " implementation only functions with " + DefaultCriteria.class.getName() + " instances.";
    public static final String DEFAULT_OPTIONS_MSG = "The " + DefaultDataStore.class.getName() + " implementation only functions with " + DefaultOptions.class.getName() + " instances.";
    public static final String HREF_REQD_MSG = "'save' may only be called on objects that have already been persisted and have an existing href attribute.";
    private static final boolean COLLECTION_CACHING_ENABLED = false;
    private final String baseUrl;
    private final ClientCredentials clientCredentials;
    private final RequestExecutor requestExecutor;
    private final ResourceFactory resourceFactory;
    private final MapMarshaller mapMarshaller;
    private final CacheManager cacheManager;
    private final CacheResolver cacheResolver;
    private final ResourceConverter resourceConverter;
    private final QueryStringFactory queryStringFactory;
    private final List<Filter> filters;
    public static final String USER_AGENT_STRING = UserAgent.getUserAgentString();

    public DefaultDataStore(RequestExecutor requestExecutor, ApiKeyCredentials apiKeyCredentials) {
        this(requestExecutor, 1, apiKeyCredentials);
    }

    public DefaultDataStore(RequestExecutor requestExecutor, int apiVersion, ApiKeyCredentials apiKeyCredentials) {
        this(requestExecutor, "https://api.stormpath.com/v" + apiVersion, apiKeyCredentials);
    }

    public DefaultDataStore(RequestExecutor requestExecutor, String baseUrl, ApiKeyCredentials apiKeyCredentials) {
        this(requestExecutor, baseUrl, apiKeyCredentials, new DisabledCacheManager());
    }

    public DefaultDataStore(RequestExecutor requestExecutor, String baseUrl, ClientCredentials clientCredentials, CacheManager cacheManager) {
        Assert.notNull((Object)baseUrl, (String)"baseUrl cannot be null");
        Assert.notNull((Object)requestExecutor, (String)"RequestExecutor cannot be null.");
        Assert.notNull((Object)clientCredentials, (String)"clientCredentials cannot be null.");
        Assert.notNull((Object)cacheManager, (String)"CacheManager cannot be null.  Use the DisabledCacheManager if you wish to turn off caching.");
        this.requestExecutor = requestExecutor;
        this.baseUrl = baseUrl;
        this.clientCredentials = clientCredentials;
        this.cacheManager = cacheManager;
        this.resourceFactory = new DefaultResourceFactory(this);
        this.mapMarshaller = new JacksonMapMarshaller();
        this.queryStringFactory = new QueryStringFactory();
        this.cacheResolver = new DefaultCacheResolver(this.cacheManager, new DefaultCacheRegionNameResolver());
        ReferenceFactory referenceFactory = new ReferenceFactory();
        this.resourceConverter = new DefaultResourceConverter(referenceFactory);
        this.filters = new ArrayList<Filter>();
        this.filters.add(new EnlistmentFilter());
        if (clientCredentials instanceof ApiKeyCredentials) {
            this.filters.add(new DecryptApiKeySecretFilter((ApiKeyCredentials)clientCredentials));
        }
        if (this.isCachingEnabled()) {
            this.filters.add(new ReadCacheFilter(this.baseUrl, this.cacheResolver, false));
            this.filters.add(new WriteCacheFilter(this.cacheResolver, false, referenceFactory));
        }
        if (clientCredentials instanceof ApiKeyCredentials) {
            this.filters.add(new ApiKeyQueryFilter(this.queryStringFactory));
        }
        this.filters.add(new ProviderAccountResultFilter());
    }

    @Override
    public CacheResolver getCacheResolver() {
        return this.cacheResolver;
    }

    public ApiKey getApiKey() {
        Assert.isInstanceOf(ApiKeyCredentials.class, (Object)this.clientCredentials);
        return ((ApiKeyCredentials)this.clientCredentials).getApiKey();
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public <T extends Resource> T instantiate(Class<T> clazz) {
        return this.resourceFactory.instantiate(clazz, new Object[0]);
    }

    @Override
    public <T extends Resource> T instantiate(Class<T> clazz, Map<String, Object> properties) {
        return this.resourceFactory.instantiate(clazz, properties);
    }

    private <T extends Resource> T instantiate(Class<T> clazz, Map<String, ?> properties, QueryString qs) {
        if (CollectionResource.class.isAssignableFrom(clazz)) {
            return this.resourceFactory.instantiate(clazz, properties, qs);
        }
        return this.resourceFactory.instantiate(clazz, properties);
    }

    @Override
    public <T extends Resource> T instantiate(Class<T> clazz, Map<String, Object> properties, boolean hrefFragment) {
        if (hrefFragment) {
            Assert.hasText((String)((String)properties.get("href")), (String)"when hrefFragment is set to true the properties map must contain an href key.");
            String hrefValue = (String)properties.get("href");
            hrefValue = this.qualify(hrefValue);
            properties.put("href", hrefValue);
        }
        return this.instantiate(clazz, properties);
    }

    public <T extends Resource> T getResource(String href, Class<T> clazz) {
        return this.getResource(href, clazz, (Options)null);
    }

    @Override
    public <T extends Resource> T getResource(String href, Class<T> clazz, Criteria criteria) {
        Assert.isInstanceOf(DefaultCriteria.class, (Object)criteria, (String)DEFAULT_CRITERIA_MSG);
        QueryString qs = this.queryStringFactory.createQueryString(href, (DefaultCriteria)criteria);
        return this.getResource(href, clazz, (Options)qs);
    }

    @Override
    public <T extends Resource> T getResource(String href, Class<T> clazz, Map<String, Object> queryParameters) {
        ResourceDataResult result = this.getResourceData(href, clazz, queryParameters);
        return this.instantiate(clazz, result.getData(), result.getUri().getQuery());
    }

    @Override
    public <T extends Resource, R extends T> R getResource(String href, Class<T> parent, String childIdProperty, Map<String, Class<? extends R>> idClassMap) {
        Class<? extends R> childClass;
        Assert.hasText((String)childIdProperty, (String)"childIdProperty cannot be null or empty.");
        Assert.notEmpty(idClassMap, (String)"idClassMap cannot be null or empty.");
        ResourceDataResult result = this.getResourceData(href, parent, null);
        Map<String, Object> data = result.getData();
        if (Collections.isEmpty(data)) {
            throw new IllegalStateException(childIdProperty + " could not be found in: " + data + ".");
        }
        String childClassName = null;
        Object val = data.get(childIdProperty);
        if (val != null) {
            childClassName = String.valueOf(val);
        }
        if ((childClass = idClassMap.get(childClassName)) == null) {
            throw new IllegalStateException("No Class mapping could be found for " + childIdProperty + ".");
        }
        return this.instantiate(childClass, data, result.getUri().getQuery());
    }

    public <T extends Resource, O extends Options> T getResource(String href, Class<T> clazz, O options) {
        Assert.hasText((String)href, (String)"href argument cannot be null or empty.");
        Assert.notNull(clazz, (String)"Resource class argument cannot be null.");
        Assert.isInstanceOf(DefaultOptions.class, options, (String)("The " + this.getClass().getName() + " implementation only functions with " + DefaultOptions.class.getName() + " instances."));
        DefaultOptions defaultOptions = (DefaultOptions)options;
        QueryString qs = this.queryStringFactory.createQueryString(defaultOptions);
        return this.getResource(href, clazz, (O)qs);
    }

    private ResourceDataResult getResourceData(String href, Class<? extends Resource> clazz, Map<String, ?> queryParameters) {
        Assert.hasText((String)href, (String)"href argument cannot be null or empty.");
        Assert.notNull(clazz, (String)"Resource class argument cannot be null.");
        DefaultFilterChain chain = new DefaultFilterChain(this.filters, new FilterChain(){

            @Override
            public ResourceDataResult filter(ResourceDataRequest req) {
                CanonicalUri uri = req.getUri();
                DefaultRequest getRequest = new DefaultRequest(HttpMethod.GET, uri.getAbsolutePath(), uri.getQuery());
                Response getResponse = DefaultDataStore.this.execute(getRequest);
                Map body = DefaultDataStore.this.getBody(getResponse);
                if (Collections.isEmpty((Map)body)) {
                    throw new IllegalStateException("Unable to obtain resource data from the API server or from cache.");
                }
                return new DefaultResourceDataResult(req.getAction(), uri, req.getResourceClass(), body);
            }
        });
        CanonicalUri uri = this.canonicalize(href, queryParameters);
        DefaultResourceDataRequest req = new DefaultResourceDataRequest(ResourceAction.READ, uri, clazz, new HashMap<String, Object>());
        return chain.filter(req);
    }

    private ResourceAction getPostAction(ResourceDataRequest request, Response response) {
        int httpStatus = response.getHttpStatus();
        if (httpStatus == 201) {
            return ResourceAction.CREATE;
        }
        if (httpStatus == 200) {
            return ResourceAction.READ;
        }
        return request.getAction();
    }

    @Override
    public <T extends Resource> T create(String parentHref, T resource) {
        return (T)this.save(parentHref, resource, null, resource.getClass(), null, true);
    }

    @Override
    public <T extends Resource> T create(String parentHref, T resource, Options options) {
        QueryString qs = this.toQueryString(parentHref, options);
        return (T)this.save(parentHref, resource, null, resource.getClass(), qs, true);
    }

    @Override
    public <T extends Resource, R extends Resource> R create(String parentHref, T resource, Class<? extends R> returnType) {
        return this.save(parentHref, resource, null, returnType, null, true);
    }

    @Override
    public <T extends Resource, R extends Resource> R create(String parentHref, T resource, Class<? extends R> returnType, HttpHeaders requestHeaders) {
        return this.save(parentHref, resource, requestHeaders, returnType, null, true);
    }

    @Override
    public <T extends Resource, R extends Resource> R create(String parentHref, T resource, Class<? extends R> returnType, Options options) {
        QueryString qs = this.toQueryString(parentHref, options);
        return this.save(parentHref, resource, null, returnType, qs, true);
    }

    @Override
    public <T extends Resource & Saveable> void save(T resource) {
        String href = resource.getHref();
        Assert.hasText((String)href, (String)HREF_REQD_MSG);
        this.save(href, resource, null, resource.getClass(), null, false);
    }

    @Override
    public <T extends Resource & Saveable> void save(T resource, Options options) {
        Assert.notNull((Object)options, (String)"options argument cannot be null.");
        String href = resource.getHref();
        Assert.hasText((String)href, (String)HREF_REQD_MSG);
        QueryString qs = this.toQueryString(href, options);
        this.save(href, resource, null, resource.getClass(), qs, false);
    }

    @Override
    public <T extends Resource & Saveable, R extends Resource> R save(T resource, Class<? extends R> returnType) {
        Assert.hasText((String)resource.getHref(), (String)HREF_REQD_MSG);
        return this.save(resource.getHref(), resource, null, returnType, null, false);
    }

    private QueryString toQueryString(String href, Options options) {
        if (options == null) {
            return null;
        }
        Assert.isInstanceOf(DefaultOptions.class, (Object)options, (String)DEFAULT_OPTIONS_MSG);
        DefaultOptions defaultOptions = (DefaultOptions)options;
        return this.queryStringFactory.createQueryString(href, defaultOptions);
    }

    private <T extends Resource, R extends Resource> R save(String href, T resource, HttpHeaders requestHeaders, final Class<? extends R> returnType, QueryString qs, boolean create) {
        Assert.hasText((String)href, (String)"href argument cannot be null or empty.");
        Assert.notNull(resource, (String)"resource argument cannot be null.");
        Assert.notNull(returnType, (String)"returnType class cannot be null.");
        Assert.isInstanceOf(AbstractResource.class, resource);
        Assert.isTrue((!CollectionResource.class.isAssignableFrom(resource.getClass()) ? 1 : 0) != 0, (String)"Collections cannot be persisted.");
        CanonicalUri uri = this.canonicalize(href, qs);
        AbstractResource abstractResource = (AbstractResource)resource;
        Map<String, Object> props = this.resourceConverter.convert(abstractResource);
        DefaultFilterChain chain = new DefaultFilterChain(this.filters, new FilterChain(){

            @Override
            public ResourceDataResult filter(ResourceDataRequest req) {
                HttpHeaders httpHeaders;
                QueryString qs;
                String bodyString = req.getHttpHeaders().getContentType() != null && req.getHttpHeaders().getContentType().equals(MediaType.APPLICATION_FORM_URLENCODED) ? DefaultDataStore.this.buildCanonicalBodyQueryParams(req.getData()) : DefaultDataStore.this.mapMarshaller.marshal(req.getData());
                StringInputStream body = new StringInputStream(bodyString);
                long length = body.available();
                CanonicalUri uri = req.getUri();
                String href = uri.getAbsolutePath();
                DefaultRequest request = new DefaultRequest(HttpMethod.POST, href, qs = uri.getQuery(), httpHeaders = req.getHttpHeaders(), body, length);
                Response response = DefaultDataStore.this.execute(request);
                Map<String, Object> responseBody = DefaultDataStore.this.getBody(response);
                if (Collections.isEmpty((Map)responseBody)) {
                    if (response.getHttpStatus() == 202) {
                        responseBody = java.util.Collections.emptyMap();
                    } else {
                        throw new IllegalStateException("Unable to obtain resource data from the API server.");
                    }
                }
                ResourceAction responseAction = DefaultDataStore.this.getPostAction(req, response);
                return new DefaultResourceDataResult(responseAction, uri, returnType, responseBody);
            }
        });
        ResourceAction action = create ? ResourceAction.CREATE : ResourceAction.UPDATE;
        DefaultResourceDataRequest request = new DefaultResourceDataRequest(action, uri, abstractResource.getClass(), props, requestHeaders);
        ResourceDataResult result = chain.filter(request);
        Map<String, Object> data = result.getData();
        if (returnType.equals(abstractResource.getClass())) {
            abstractResource.setProperties(data);
        }
        return this.resourceFactory.instantiate(returnType, data);
    }

    @Override
    public <T extends Resource> void delete(T resource) {
        this.doDelete(resource, null);
    }

    @Override
    public <T extends Resource> void deleteResourceProperty(T resource, String propertyName) {
        Assert.hasText((String)propertyName, (String)"propertyName cannot be null or empty.");
        this.doDelete(resource, propertyName);
    }

    private String buildCanonicalBodyQueryParams(Map<String, Object> bodyData) {
        StringBuilder builder = new StringBuilder();
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>(bodyData);
        try {
            for (Map.Entry entry : treeMap.entrySet()) {
                if (builder.length() > 0) {
                    builder.append(APPEND_PARAM_CHAR);
                }
                builder.append(String.format("%s=%s", URLEncoder.encode((String)entry.getKey(), "UTF-8"), URLEncoder.encode(entry.getValue().toString(), "UTF-8")));
            }
        }
        catch (UnsupportedEncodingException e) {
            log.trace("Body content could not be properly encoded");
            return null;
        }
        return builder.toString();
    }

    private <T extends Resource> void doDelete(T resource, String possiblyNullPropertyName) {
        Assert.notNull(resource, (String)"resource argument cannot be null.");
        Assert.isInstanceOf(AbstractResource.class, resource, (String)"Resource argument must be an AbstractResource.");
        AbstractResource abstractResource = (AbstractResource)resource;
        String resourceHref = abstractResource.getHref();
        final String requestHref = Strings.hasText((String)possiblyNullPropertyName) ? resourceHref + "/" + possiblyNullPropertyName : resourceHref;
        DefaultFilterChain chain = new DefaultFilterChain(this.filters, new FilterChain(){

            @Override
            public ResourceDataResult filter(ResourceDataRequest request) {
                DefaultRequest deleteRequest = new DefaultRequest(HttpMethod.DELETE, requestHref);
                DefaultDataStore.this.execute(deleteRequest);
                return new DefaultResourceDataResult(request.getAction(), request.getUri(), request.getResourceClass(), new HashMap<String, Object>());
            }
        });
        CanonicalUri resourceUri = this.canonicalize(resourceHref, null);
        DefaultResourceDataRequest request = new DefaultResourceDataRequest(ResourceAction.DELETE, resourceUri, resource.getClass(), new HashMap<String, Object>());
        chain.filter(request);
    }

    public boolean isCachingEnabled() {
        return this.cacheManager != null && !(this.cacheManager instanceof DisabledCacheManager);
    }

    private Response execute(Request request) throws ResourceException {
        this.applyDefaultRequestHeaders(request);
        Response response = this.requestExecutor.executeRequest(request);
        log.trace("Executed HTTP request.");
        if (response.isError()) {
            Map<String, Object> body = this.getBody(response);
            String requestId = response.getHeaders().getStormpathRequestId();
            if (Strings.hasText((String)requestId)) {
                body.put(DefaultError.REQUEST_ID.getName(), requestId);
            }
            DefaultError error = new DefaultError(body);
            throw new ResourceException((Error)error);
        }
        return response;
    }

    private Map<String, Object> getBody(Response response) {
        Assert.notNull((Object)response, (String)"response argument cannot be null.");
        Map<String, Object> out = null;
        if (response.hasBody()) {
            out = this.mapMarshaller.unmarshall(response.getBody());
        }
        return out;
    }

    protected void applyDefaultRequestHeaders(Request request) {
        request.getHeaders().setAccept(java.util.Collections.singletonList(MediaType.APPLICATION_JSON));
        Map<String, List<String>> headerMap = HttpHeadersHolder.get();
        String stormpathAgentHeaderName = "X-Stormpath-Agent".toLowerCase();
        if (headerMap != null && headerMap.get(stormpathAgentHeaderName) != null) {
            List<String> stormpathAgents = headerMap.get(stormpathAgentHeaderName);
            if (stormpathAgents != null && stormpathAgents.size() > 0) {
                String stormpathAgent = Strings.arrayToDelimitedString((Object[])stormpathAgents.toArray(), (String)" ");
                request.getHeaders().set("User-Agent", stormpathAgent + " " + USER_AGENT_STRING);
            }
        } else {
            request.getHeaders().set("User-Agent", USER_AGENT_STRING);
        }
        if (request.getHeaders().getContentType() == null && request.getBody() != null) {
            request.getHeaders().setContentType(MediaType.APPLICATION_JSON);
        }
    }

    protected CanonicalUri canonicalize(String href, Map<String, ?> queryParams) {
        href = this.ensureFullyQualified(href);
        return DefaultCanonicalUri.create(href, queryParams);
    }

    protected String ensureFullyQualified(String href) {
        String value = href;
        if (!this.isFullyQualified(href)) {
            value = this.qualify(href);
        }
        return value;
    }

    protected boolean isFullyQualified(String href) {
        if (href == null || href.length() < 5) {
            return false;
        }
        char c = href.charAt(0);
        return !(c != 'h' && c != 'H' || (c = href.charAt(1)) != 't' && c != 'T' || (c = href.charAt(2)) != 't' && c != 'T' || (c = href.charAt(3)) != 'p' && c != 'P');
    }

    protected String qualify(String href) {
        StringBuilder sb = new StringBuilder(this.baseUrl);
        if (!href.startsWith("/")) {
            sb.append("/");
        }
        sb.append(href);
        return sb.toString();
    }

    private static String toString(InputStream is) {
        try {
            return new Scanner(is, "UTF-8").useDelimiter("\\A").next();
        }
        catch (NoSuchElementException e) {
            log.trace("Response body input stream did not contain any content.", (Throwable)e);
            return null;
        }
    }
}

