/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.config;

import com.stormpath.sdk.impl.config.PropertiesSource;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class FilteredPropertiesSource
implements PropertiesSource {
    private final PropertiesSource propertiesSource;
    private final Filter filter;

    public FilteredPropertiesSource(PropertiesSource propertiesSource, Filter filter) {
        Assert.notNull((Object)propertiesSource, (String)"source cannot be null.");
        Assert.notNull((Object)filter, (String)"filter cannot be null.");
        this.propertiesSource = propertiesSource;
        this.filter = filter;
    }

    @Override
    public Map<String, String> getProperties() {
        Map<String, String> props = this.propertiesSource.getProperties();
        LinkedHashMap<String, String> retained = new LinkedHashMap<String, String>();
        if (!Collections.isEmpty(props)) {
            Set<String> keys = props.keySet();
            for (String key : keys) {
                String value;
                String[] evaluated = this.filter.map(key, value = props.get(key));
                if (evaluated == null) continue;
                Assert.isTrue((2 == evaluated.length ? 1 : 0) != 0, (String)"Filter returned string array must have a length of 2 (key/value pair)");
                retained.put(evaluated[0], evaluated[1]);
            }
        }
        return retained;
    }

    public static interface Filter {
        public String[] map(String var1, String var2);
    }
}

