/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.config;

import com.stormpath.sdk.impl.config.PropertiesParser;
import com.stormpath.sdk.impl.io.Resource;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPropertiesParser
implements PropertiesParser {
    private static final Logger log = LoggerFactory.getLogger(DefaultPropertiesParser.class);
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";
    public static final String COMMENT_POUND = "#";
    public static final String COMMENT_SEMICOLON = ";";
    protected static final char ESCAPE_TOKEN = '\\';

    @Override
    public Map<String, String> parse(String source) {
        Scanner scanner = new Scanner(source);
        return this.parse(scanner);
    }

    @Override
    public Map<String, String> parse(Resource resource) throws IOException {
        InputStream is = resource.getInputStream();
        Scanner scanner = new Scanner(is, DEFAULT_CHARSET_NAME);
        return this.parse(scanner);
    }

    @Override
    public Map<String, String> parse(Scanner scanner) {
        Assert.notNull((Object)scanner, (String)"Scanner argument cannot be null.");
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        StringBuilder lineBuffer = new StringBuilder();
        while (scanner.hasNextLine()) {
            String rawLine = scanner.nextLine();
            String line = Strings.clean((String)rawLine);
            if (line == null || line.startsWith(COMMENT_POUND) || line.startsWith(COMMENT_SEMICOLON)) continue;
            if (DefaultPropertiesParser.isContinued(line)) {
                line = line.substring(0, line.length() - 1);
                lineBuffer.append(line);
                continue;
            }
            lineBuffer.append(line);
            line = lineBuffer.toString();
            lineBuffer = new StringBuilder();
            String[] kvPair = DefaultPropertiesParser.splitKeyValue(line);
            props.put(kvPair[0], kvPair[1]);
        }
        return props;
    }

    protected static boolean isContinued(String line) {
        if (!Strings.hasText((String)line)) {
            return false;
        }
        int length = line.length();
        int backslashCount = 0;
        for (int i = length - 1; i > 0 && line.charAt(i) == '\\'; --i) {
            ++backslashCount;
        }
        return backslashCount % 2 != 0;
    }

    private static boolean isKeyValueSeparatorChar(char c) {
        return Character.isWhitespace(c) || c == ':' || c == '=';
    }

    private static boolean isCharEscaped(CharSequence s, int index) {
        return index > 0 && s.charAt(index - 1) == '\\';
    }

    protected static String[] splitKeyValue(String keyValueLine) {
        String line = Strings.clean((String)keyValueLine);
        if (line == null) {
            return null;
        }
        StringBuilder keyBuffer = new StringBuilder();
        StringBuilder valueBuffer = new StringBuilder();
        boolean buildingKey = true;
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (buildingKey) {
                if (DefaultPropertiesParser.isKeyValueSeparatorChar(c) && !DefaultPropertiesParser.isCharEscaped(line, i)) {
                    buildingKey = false;
                    continue;
                }
                keyBuffer.append(c);
                continue;
            }
            if (valueBuffer.length() == 0 && DefaultPropertiesParser.isKeyValueSeparatorChar(c) && !DefaultPropertiesParser.isCharEscaped(line, i)) continue;
            valueBuffer.append(c);
        }
        String key = Strings.clean((String)keyBuffer.toString());
        String value = Strings.clean((String)valueBuffer.toString());
        if (key == null) {
            String msg = "Line argument must contain a key. None was found.";
            throw new IllegalArgumentException(msg);
        }
        log.trace("Discovered key/value pair: {} = {}", (Object)key, (Object)value);
        return new String[]{key, value};
    }
}

