/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.client;

import com.stormpath.sdk.account.Account;
import com.stormpath.sdk.account.AccountCriteria;
import com.stormpath.sdk.account.AccountList;
import com.stormpath.sdk.api.ApiKey;
import com.stormpath.sdk.application.Application;
import com.stormpath.sdk.application.ApplicationCriteria;
import com.stormpath.sdk.application.ApplicationList;
import com.stormpath.sdk.application.CreateApplicationRequest;
import com.stormpath.sdk.cache.CacheManager;
import com.stormpath.sdk.client.AuthenticationScheme;
import com.stormpath.sdk.client.Client;
import com.stormpath.sdk.client.Proxy;
import com.stormpath.sdk.directory.CreateDirectoryRequest;
import com.stormpath.sdk.directory.Directory;
import com.stormpath.sdk.directory.DirectoryCriteria;
import com.stormpath.sdk.directory.DirectoryList;
import com.stormpath.sdk.ds.DataStore;
import com.stormpath.sdk.group.GroupCriteria;
import com.stormpath.sdk.group.GroupList;
import com.stormpath.sdk.impl.authc.credentials.ClientCredentials;
import com.stormpath.sdk.impl.ds.DefaultDataStore;
import com.stormpath.sdk.impl.http.RequestExecutor;
import com.stormpath.sdk.impl.http.authc.RequestAuthenticatorFactory;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Classes;
import com.stormpath.sdk.organization.CreateOrganizationRequest;
import com.stormpath.sdk.organization.Organization;
import com.stormpath.sdk.organization.OrganizationCriteria;
import com.stormpath.sdk.organization.OrganizationList;
import com.stormpath.sdk.query.Options;
import com.stormpath.sdk.resource.Resource;
import com.stormpath.sdk.resource.ResourceException;
import com.stormpath.sdk.tenant.Tenant;
import com.stormpath.sdk.tenant.TenantOptions;
import java.lang.reflect.Constructor;
import java.util.Map;

public class DefaultClient
implements Client {
    private final DataStore dataStore;
    private String currentTenantHref;

    public DefaultClient(ClientCredentials clientCredentials, String baseUrl, Proxy proxy, CacheManager cacheManager, AuthenticationScheme authenticationScheme, RequestAuthenticatorFactory requestAuthenticatorFactory, int connectionTimeout) {
        Assert.notNull((Object)clientCredentials, (String)"clientCredentials argument cannot be null.");
        Assert.isTrue((connectionTimeout >= 0 ? 1 : 0) != 0, (String)"connectionTimeout cannot be a negative number.");
        RequestExecutor requestExecutor = this.createRequestExecutor(clientCredentials, proxy, authenticationScheme, requestAuthenticatorFactory, connectionTimeout);
        this.dataStore = this.createDataStore(requestExecutor, baseUrl, clientCredentials, cacheManager);
    }

    protected DataStore createDataStore(RequestExecutor requestExecutor, String baseUrl, ClientCredentials clientCredentials, CacheManager cacheManager) {
        return new DefaultDataStore(requestExecutor, baseUrl, clientCredentials, cacheManager);
    }

    public Tenant getCurrentTenant() {
        String href = this.currentTenantHref;
        if (href == null) {
            href = "/tenants/current";
        }
        Tenant current = (Tenant)this.dataStore.getResource(href, Tenant.class);
        this.currentTenantHref = current.getHref();
        return current;
    }

    public ApiKey getApiKey() {
        return this.dataStore.getApiKey();
    }

    public CacheManager getCacheManager() {
        return this.dataStore.getCacheManager();
    }

    public DataStore getDataStore() {
        return this.dataStore;
    }

    private RequestExecutor createRequestExecutor(ClientCredentials clientCredentials, Proxy proxy, AuthenticationScheme authenticationScheme, RequestAuthenticatorFactory requestAuthenticatorFactory, int connectionTimeout) {
        String className = "com.stormpath.sdk.impl.http.httpclient.HttpClientRequestExecutor";
        if (!Classes.isAvailable((String)className)) {
            String msg = "Unable to find the '" + className + "' implementation on the classpath.  Please ensure you " + "have added the stormpath-sdk-httpclient .jar file to your runtime classpath.";
            throw new RuntimeException(msg);
        }
        Class requestExecutorClass = Classes.forName((String)className);
        Constructor ctor = Classes.getConstructor((Class)requestExecutorClass, (Class[])new Class[]{ClientCredentials.class, Proxy.class, AuthenticationScheme.class, RequestAuthenticatorFactory.class, Integer.class});
        return (RequestExecutor)Classes.instantiate((Constructor)ctor, (Object[])new Object[]{clientCredentials, proxy, authenticationScheme, requestAuthenticatorFactory, connectionTimeout});
    }

    public <T extends Resource> T instantiate(Class<T> clazz) {
        return (T)this.dataStore.instantiate(clazz);
    }

    public <T extends Resource> T getResource(String href, Class<T> clazz) {
        return (T)this.dataStore.getResource(href, clazz);
    }

    public <T extends Resource, O extends Options> T getResource(String href, Class<T> clazz, O options) {
        return (T)this.dataStore.getResource(href, clazz, options);
    }

    public Application createApplication(Application application) throws ResourceException {
        return this.getCurrentTenant().createApplication(application);
    }

    public Application createApplication(CreateApplicationRequest request) throws ResourceException {
        return this.getCurrentTenant().createApplication(request);
    }

    public ApplicationList getApplications() {
        return this.getCurrentTenant().getApplications();
    }

    public ApplicationList getApplications(Map<String, Object> queryParams) {
        return this.getCurrentTenant().getApplications(queryParams);
    }

    public ApplicationList getApplications(ApplicationCriteria criteria) {
        return this.getCurrentTenant().getApplications(criteria);
    }

    public Directory createDirectory(Directory directory) {
        return this.getCurrentTenant().createDirectory(directory);
    }

    public Organization createOrganization(Organization organization) {
        return this.getCurrentTenant().createOrganization(organization);
    }

    public Organization createOrganization(CreateOrganizationRequest request) throws ResourceException {
        return this.getCurrentTenant().createOrganization(request);
    }

    public OrganizationList getOrganizations() {
        return this.getCurrentTenant().getOrganizations();
    }

    public OrganizationList getOrganizations(Map<String, Object> queryParams) {
        return this.getCurrentTenant().getOrganizations(queryParams);
    }

    public OrganizationList getOrganizations(OrganizationCriteria criteria) {
        return this.getCurrentTenant().getOrganizations(criteria);
    }

    public Directory createDirectory(CreateDirectoryRequest createDirectoryRequest) throws ResourceException {
        return this.getCurrentTenant().createDirectory(createDirectoryRequest);
    }

    public DirectoryList getDirectories() {
        return this.getCurrentTenant().getDirectories();
    }

    public DirectoryList getDirectories(Map<String, Object> queryParams) {
        return this.getCurrentTenant().getDirectories(queryParams);
    }

    public DirectoryList getDirectories(DirectoryCriteria criteria) {
        return this.getCurrentTenant().getDirectories(criteria);
    }

    public Account verifyAccountEmail(String token) {
        return this.getCurrentTenant().verifyAccountEmail(token);
    }

    public AccountList getAccounts() {
        return this.getCurrentTenant().getAccounts();
    }

    public AccountList getAccounts(AccountCriteria criteria) {
        return this.getCurrentTenant().getAccounts(criteria);
    }

    public AccountList getAccounts(Map<String, Object> queryParams) {
        return this.getCurrentTenant().getAccounts(queryParams);
    }

    public GroupList getGroups() {
        return this.getCurrentTenant().getGroups();
    }

    public GroupList getGroups(GroupCriteria criteria) {
        return this.getCurrentTenant().getGroups(criteria);
    }

    public GroupList getGroups(Map<String, Object> queryParams) {
        return this.getCurrentTenant().getGroups(queryParams);
    }

    public Tenant getCurrentTenant(TenantOptions tenantOptions) {
        String href = this.currentTenantHref;
        if (href == null) {
            href = "/tenants/current";
        }
        Tenant current = (Tenant)this.dataStore.getResource(href, Tenant.class, (Options)tenantOptions);
        this.currentTenantHref = current.getHref();
        return current;
    }
}

