/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.cache;

import com.stormpath.sdk.cache.CacheConfigurationBuilder;
import com.stormpath.sdk.cache.CacheManager;
import com.stormpath.sdk.cache.CacheManagerBuilder;
import com.stormpath.sdk.impl.cache.CacheConfiguration;
import com.stormpath.sdk.impl.cache.DefaultCacheConfiguration;
import com.stormpath.sdk.impl.cache.DefaultCacheConfigurationBuilder;
import com.stormpath.sdk.impl.cache.DefaultCacheManager;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Collections;
import com.stormpath.sdk.lang.Duration;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class DefaultCacheManagerBuilder
implements CacheManagerBuilder {
    private Duration defaultTimeToLive;
    private Duration defaultTimeToIdle;
    private final Set<CacheConfiguration> configs = new LinkedHashSet<CacheConfiguration>();

    public CacheManagerBuilder withDefaultTimeToLive(long ttl, TimeUnit timeUnit) {
        this.defaultTimeToLive = DefaultCacheConfiguration.toDuration(ttl, timeUnit);
        return this;
    }

    public CacheManagerBuilder withDefaultTimeToIdle(long tti, TimeUnit timeUnit) {
        this.defaultTimeToIdle = DefaultCacheConfiguration.toDuration(tti, timeUnit);
        return this;
    }

    public CacheManagerBuilder withCache(CacheConfigurationBuilder builder) {
        Assert.isInstanceOf(DefaultCacheConfigurationBuilder.class, (Object)builder, (String)("This implementation only accepts " + DefaultCacheConfigurationBuilder.class.getName() + " instances."));
        DefaultCacheConfigurationBuilder b = (DefaultCacheConfigurationBuilder)builder;
        this.configs.add(b.build());
        return this;
    }

    public CacheManager build() {
        DefaultCacheManager manager = new DefaultCacheManager();
        if (this.defaultTimeToLive != null) {
            manager.setDefaultTimeToLive(this.defaultTimeToLive);
        }
        if (this.defaultTimeToIdle != null) {
            manager.setDefaultTimeToIdle(this.defaultTimeToIdle);
        }
        if (!Collections.isEmpty(this.configs)) {
            manager.setCacheConfigurations(this.configs);
        }
        return manager;
    }
}

