/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.authc.credentials;

import com.stormpath.sdk.impl.authc.credentials.ClientCredentials;
import com.stormpath.sdk.impl.authc.credentials.ClientCredentialsProvider;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClientCredentialsProviderChain
implements ClientCredentialsProvider {
    private static final Logger log = LoggerFactory.getLogger(ClientCredentialsProviderChain.class);
    private List<ClientCredentialsProvider> clientCredentialsProviders = new ArrayList<ClientCredentialsProvider>();

    public void addClientCredentialsProviders(ClientCredentialsProvider ... clientCredentialsProviders) {
        for (ClientCredentialsProvider clientCredentialsProvider : clientCredentialsProviders) {
            this.clientCredentialsProviders.add(clientCredentialsProvider);
        }
    }

    @Override
    public ClientCredentials getClientCredentials() {
        for (ClientCredentialsProvider clientCredentialsProvider : this.clientCredentialsProviders) {
            try {
                return clientCredentialsProvider.getClientCredentials();
            }
            catch (Throwable throwable) {
                log.debug("Unable to load credentials from " + clientCredentialsProvider.toString() + ": " + throwable.getMessage());
            }
        }
        throw new IllegalStateException("Unable to load credentials from any provider in the chain.");
    }

    protected List<ClientCredentialsProvider> getClientCredentialsProviders() {
        return this.clientCredentialsProviders;
    }
}

