/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.authc;

import com.stormpath.sdk.authc.AuthenticationRequest;
import com.stormpath.sdk.error.authc.OAuthAuthenticationException;
import com.stormpath.sdk.http.HttpRequest;
import com.stormpath.sdk.impl.error.ApiAuthenticationExceptionFactory;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Classes;
import com.stormpath.sdk.oauth.RequestLocation;
import java.lang.reflect.Constructor;

public class OAuthAuthenticationRequestFactory {
    public static final OAuthAuthenticationRequestFactory INSTANCE = new OAuthAuthenticationRequestFactory();
    private static final String BASIC_OAUTH_REQUEST_FQCN = "com.stormpath.sdk.impl.oauth.authc.AccessTokenAuthenticationRequest";
    private static final String BEARER_OAUTH_REQUEST_FQCN = "com.stormpath.sdk.impl.oauth.authc.ResourceAuthenticationRequest";
    private static final String OAUTH_REQUEST_NOT_AVAILABLE_MSG = "Unable to find the OAuthRequest implementation on the classpath. Please ensure you have added the stormpath-sdk-oauth-{version}.jar file to your runtime classpath.";

    public AuthenticationRequest createRequest(HttpRequest request, RequestLocation[] requestLocations) {
        Assert.isTrue((boolean)Classes.isAvailable((String)BEARER_OAUTH_REQUEST_FQCN), (String)OAUTH_REQUEST_NOT_AVAILABLE_MSG);
        Class clazz = Classes.forName((String)BEARER_OAUTH_REQUEST_FQCN);
        Constructor constructor = Classes.getConstructor((Class)clazz, (Class[])new Class[]{HttpRequest.class, RequestLocation[].class});
        return this.instantiate(constructor, request, requestLocations);
    }

    public AuthenticationRequest createTokenRequest(HttpRequest request) {
        Assert.isTrue((boolean)Classes.isAvailable((String)BASIC_OAUTH_REQUEST_FQCN), (String)OAUTH_REQUEST_NOT_AVAILABLE_MSG);
        Class clazz = Classes.forName((String)BASIC_OAUTH_REQUEST_FQCN);
        Constructor constructor = Classes.getConstructor((Class)clazz, (Class[])new Class[]{HttpRequest.class});
        return this.instantiate(constructor, request);
    }

    protected AuthenticationRequest instantiate(Constructor<AuthenticationRequest> ctor, Object ... args) {
        try {
            return (AuthenticationRequest)Classes.instantiate(ctor, (Object[])args);
        }
        catch (Exception e) {
            throw ApiAuthenticationExceptionFactory.newOAuthException(OAuthAuthenticationException.class, "invalid_request");
        }
    }
}

