/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.authc;

import com.stormpath.sdk.api.ApiAuthenticationResult;
import com.stormpath.sdk.api.ApiRequestAuthenticator;
import com.stormpath.sdk.application.Application;
import com.stormpath.sdk.authc.AuthenticationRequest;
import com.stormpath.sdk.authc.AuthenticationResult;
import com.stormpath.sdk.http.HttpRequest;
import com.stormpath.sdk.impl.application.DefaultApplication;
import com.stormpath.sdk.impl.authc.ApiAuthenticationRequestFactory;
import com.stormpath.sdk.lang.Assert;
import java.util.HashSet;
import java.util.Set;

public class DefaultApiRequestAuthenticator
implements ApiRequestAuthenticator {
    private static final ApiAuthenticationRequestFactory FACTORY = new ApiAuthenticationRequestFactory();
    private final Application application;
    private HttpRequest httpRequest;
    private static final Set<Class> HTTP_REQUEST_SUPPORTED_CLASSES;
    private static final String HTTP_REQUEST_NOT_SUPPORTED_MSG = "Class [%s] is not one of the supported http requests classes [%s].";

    public DefaultApiRequestAuthenticator(Application application, HttpRequest httpRequest) {
        Assert.notNull((Object)application, (String)"application argument cannot be null.");
        Assert.notNull((Object)httpRequest, (String)"httpRequest argument cannot be null.");
        this.application = application;
        this.httpRequest = httpRequest;
    }

    public DefaultApiRequestAuthenticator(DefaultApplication application) {
        Assert.notNull((Object)application, (String)"application argument cannot be null.");
        this.application = application;
    }

    protected ApiAuthenticationResult execute() {
        AuthenticationRequest request = FACTORY.createFrom(this.httpRequest);
        AuthenticationResult result = this.application.authenticateAccount(request);
        Assert.isInstanceOf(ApiAuthenticationResult.class, (Object)result);
        return (ApiAuthenticationResult)result;
    }

    public ApiAuthenticationResult authenticate(HttpRequest httpRequest) {
        Assert.notNull((Object)httpRequest, (String)"httpRequest argument cannot be null.");
        this.httpRequest = httpRequest;
        return this.execute();
    }

    static {
        HashSet<Class> supportedClasses = new HashSet<Class>();
        supportedClasses.add(HttpRequest.class);
        HTTP_REQUEST_SUPPORTED_CLASSES = supportedClasses;
    }
}

