/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.authc;

import com.stormpath.sdk.authc.AuthenticationOptions;
import com.stormpath.sdk.authc.AuthenticationRequest;
import com.stormpath.sdk.authc.AuthenticationResult;
import com.stormpath.sdk.impl.authc.BasicLoginAttempt;
import com.stormpath.sdk.impl.authc.DefaultUsernamePasswordRequest;
import com.stormpath.sdk.impl.ds.InternalDataStore;
import com.stormpath.sdk.impl.util.Base64;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.query.Options;
import java.io.UnsupportedEncodingException;

public class BasicAuthenticator {
    private InternalDataStore dataStore;

    public BasicAuthenticator(InternalDataStore dataStore) {
        Assert.notNull((Object)dataStore);
        this.dataStore = dataStore;
    }

    public AuthenticationResult authenticate(String parentHref, AuthenticationRequest request) {
        byte[] valueBytes;
        Assert.notNull((Object)parentHref, (String)"href argument must be specified");
        if (!(request instanceof DefaultUsernamePasswordRequest)) {
            throw new IllegalArgumentException("Only DefaultUsernamePasswordRequest instances are supported.");
        }
        String username = (String)request.getPrincipals();
        username = username != null ? username : "";
        char[] password = (char[])request.getCredentials();
        String pwString = password != null && password.length > 0 ? new String(password) : "";
        String value = username + ":" + pwString;
        try {
            valueBytes = value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Unable to acquire UTF-8 bytes!");
        }
        value = Base64.encodeBase64String(valueBytes);
        BasicLoginAttempt attempt = (BasicLoginAttempt)this.dataStore.instantiate(BasicLoginAttempt.class);
        attempt.setType("basic");
        attempt.setValue(value);
        if (request.getAccountStore() != null) {
            attempt.setAccountStore(request.getAccountStore());
        }
        String href = parentHref + "/loginAttempts";
        AuthenticationOptions options = request.getResponseOptions();
        if (options != null) {
            return this.dataStore.create(href, attempt, AuthenticationResult.class, (Options)options);
        }
        return this.dataStore.create(href, attempt, AuthenticationResult.class);
    }
}

