/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.authc;

import com.stormpath.sdk.application.Application;
import com.stormpath.sdk.authc.AuthenticationRequest;
import com.stormpath.sdk.authc.AuthenticationResult;
import com.stormpath.sdk.impl.authc.BasicApiAuthenticator;
import com.stormpath.sdk.impl.authc.BasicAuthenticator;
import com.stormpath.sdk.impl.authc.DefaultBasicApiAuthenticationRequest;
import com.stormpath.sdk.impl.authc.DefaultUsernamePasswordRequest;
import com.stormpath.sdk.impl.ds.InternalDataStore;
import com.stormpath.sdk.lang.Assert;

public class AuthenticationRequestDispatcher {
    protected static final String UNSUPPORTED_AUTH_REQUEST_MSG = "The AuthenticationRequest [%s] is not supported by this implementation.";

    public AuthenticationResult authenticate(InternalDataStore dataStore, Application application, AuthenticationRequest request) {
        Assert.notNull((Object)dataStore, (String)"datastore cannot be null.");
        Assert.notNull((Object)application, (String)"application cannot be null.");
        Assert.notNull((Object)request, (String)"request cannot be null.");
        if (request instanceof DefaultUsernamePasswordRequest) {
            return new BasicAuthenticator(dataStore).authenticate(application.getHref(), request);
        }
        if (request instanceof DefaultBasicApiAuthenticationRequest) {
            return new BasicApiAuthenticator(dataStore).authenticate(application, (DefaultBasicApiAuthenticationRequest)request);
        }
        throw new UnsupportedOperationException(String.format(UNSUPPORTED_AUTH_REQUEST_MSG, request.getClass().getName()));
    }
}

