/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.application;

import com.stormpath.sdk.accountStoreMapping.AccountStoreMapping;
import com.stormpath.sdk.directory.AccountStore;
import com.stormpath.sdk.directory.Directory;
import com.stormpath.sdk.group.Group;
import com.stormpath.sdk.impl.ds.InternalDataStore;
import com.stormpath.sdk.impl.resource.AbstractInstanceResource;
import com.stormpath.sdk.impl.resource.BooleanProperty;
import com.stormpath.sdk.impl.resource.IntegerProperty;
import com.stormpath.sdk.impl.resource.ResourceReference;
import com.stormpath.sdk.organization.Organization;
import com.stormpath.sdk.resource.Resource;
import java.util.Map;

public abstract class AbstractAccountStoreMapping<T extends AccountStoreMapping>
extends AbstractInstanceResource
implements AccountStoreMapping {
    public static final IntegerProperty LIST_INDEX = new IntegerProperty("listIndex");
    public static final BooleanProperty DEFAULT_ACCOUNT_STORE = new BooleanProperty("isDefaultAccountStore");
    public static final BooleanProperty DEFAULT_GROUP_STORE = new BooleanProperty("isDefaultGroupStore");
    public static final ResourceReference<AccountStore> ACCOUNT_STORE = new ResourceReference<AccountStore>("accountStore", AccountStore.class);

    public AbstractAccountStoreMapping(InternalDataStore dataStore) {
        super(dataStore);
    }

    public AbstractAccountStoreMapping(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    public AccountStore getAccountStore() {
        String href = this.getAccountStoreHref();
        AccountStore accountStore = null;
        if (href.contains("/directories/")) {
            accountStore = (AccountStore)this.getDataStore().getResource(href, Directory.class);
        } else if (href.contains("/groups/")) {
            accountStore = (AccountStore)this.getDataStore().getResource(href, Group.class);
        } else if (href.contains("/organizations/")) {
            accountStore = (AccountStore)this.getDataStore().getResource(href, Organization.class);
        }
        return accountStore;
    }

    private String getAccountStoreHref() {
        Map map = (Map)this.getProperty(ACCOUNT_STORE.getName());
        String href = null;
        if (map != null && !map.isEmpty()) {
            href = (String)map.get("href");
        }
        return href;
    }

    public AccountStoreMapping setAccountStore(AccountStore accountStore) {
        this.setResourceProperty(ACCOUNT_STORE, (Resource)accountStore);
        return this;
    }

    public int getListIndex() {
        return this.getInt(LIST_INDEX);
    }

    public T setListIndex(int listIndex) {
        this.setProperty(LIST_INDEX, (Object)listIndex);
        return (T)this;
    }

    public boolean isDefaultAccountStore() {
        return this.getBoolean(DEFAULT_ACCOUNT_STORE);
    }

    public T setDefaultAccountStore(boolean defaultAccountStore) {
        this.setProperty(DEFAULT_ACCOUNT_STORE, (Object)defaultAccountStore);
        return (T)this;
    }

    public T setDefaultGroupStore(boolean defaultGroupStore) {
        this.setProperty(DEFAULT_GROUP_STORE, (Object)defaultGroupStore);
        return (T)this;
    }

    public boolean isDefaultGroupStore() {
        return this.getBoolean(DEFAULT_GROUP_STORE);
    }

    public void delete() {
        this.getDataStore().delete(this);
    }
}

