/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.api;

import com.stormpath.sdk.account.Account;
import com.stormpath.sdk.api.ApiKey;
import com.stormpath.sdk.api.ApiKeyOptions;
import com.stormpath.sdk.api.ApiKeyStatus;
import com.stormpath.sdk.impl.ds.InternalDataStore;
import com.stormpath.sdk.impl.resource.AbstractInstanceResource;
import com.stormpath.sdk.impl.resource.Property;
import com.stormpath.sdk.impl.resource.ResourceReference;
import com.stormpath.sdk.impl.resource.StatusProperty;
import com.stormpath.sdk.impl.resource.StringProperty;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.query.Options;
import com.stormpath.sdk.tenant.Tenant;
import java.util.Map;

public class DefaultApiKey
extends AbstractInstanceResource
implements ApiKey {
    static final StringProperty ID = new StringProperty("id");
    public static final StringProperty SECRET = new StringProperty("secret");
    static final StatusProperty<ApiKeyStatus> STATUS = new StatusProperty<ApiKeyStatus>(ApiKeyStatus.class);
    static final ResourceReference<Account> ACCOUNT = new ResourceReference<Account>("account", Account.class);
    static final ResourceReference<Tenant> TENANT = new ResourceReference<Tenant>("tenant", Tenant.class);
    static final Map<String, Property> PROPERTY_DESCRIPTORS = DefaultApiKey.createPropertyDescriptorMap(ID, SECRET, STATUS, ACCOUNT, TENANT);

    public DefaultApiKey(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultApiKey(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public String getId() {
        return this.getString(ID);
    }

    public String getSecret() {
        return this.getString(SECRET);
    }

    public ApiKeyStatus getStatus() {
        String value = this.getStringProperty(STATUS.getName());
        if (value == null) {
            return null;
        }
        return ApiKeyStatus.valueOf((String)value.toUpperCase());
    }

    public void setStatus(ApiKeyStatus status) {
        this.setProperty(STATUS, (Object)status.name());
    }

    public Account getAccount() {
        return this.getResourceProperty(ACCOUNT);
    }

    public Tenant getTenant() {
        return this.getResourceProperty(TENANT);
    }

    public void delete() {
        this.getDataStore().delete(this);
    }

    public void save(ApiKeyOptions options) {
        Assert.notNull((Object)options, (String)"options argument cannot be null.");
        this.getDataStore().save(this, (Options)options);
    }

    @Override
    protected boolean isPrintableProperty(String name) {
        return !SECRET.getName().equalsIgnoreCase(name);
    }
}

