/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.api;

import com.stormpath.sdk.account.Account;
import com.stormpath.sdk.api.ApiKey;
import com.stormpath.sdk.api.ApiKeyOptions;
import com.stormpath.sdk.api.ApiKeyStatus;
import com.stormpath.sdk.lang.Strings;
import com.stormpath.sdk.tenant.Tenant;

public class ClientApiKey
implements ApiKey {
    private final String id;
    private final String secret;
    private static final String METHOD_ERROR_MESSAGE = "This method is not accessible from a client api key. Only getId() and getSecret() are available from this instance.";

    public ClientApiKey(String id, String secret) {
        if (!Strings.hasText((String)id)) {
            throw new IllegalArgumentException("API key id cannot be null or empty.");
        }
        if (!Strings.hasText((String)secret)) {
            throw new IllegalArgumentException("API key secret cannot be null or empty.");
        }
        this.id = id;
        this.secret = secret;
    }

    public String getId() {
        return this.id;
    }

    public String getSecret() {
        return this.secret;
    }

    public ApiKeyStatus getStatus() {
        throw new IllegalAccessError(METHOD_ERROR_MESSAGE);
    }

    public void setStatus(ApiKeyStatus status) {
        throw new IllegalAccessError(METHOD_ERROR_MESSAGE);
    }

    public Account getAccount() {
        throw new IllegalAccessError(METHOD_ERROR_MESSAGE);
    }

    public Tenant getTenant() {
        throw new IllegalAccessError(METHOD_ERROR_MESSAGE);
    }

    public void save(ApiKeyOptions options) {
        throw new IllegalAccessError(METHOD_ERROR_MESSAGE);
    }

    public void delete() {
        throw new IllegalAccessError(METHOD_ERROR_MESSAGE);
    }

    public String getHref() {
        throw new IllegalAccessError(METHOD_ERROR_MESSAGE);
    }

    public void save() {
        throw new IllegalAccessError(METHOD_ERROR_MESSAGE);
    }

    public String toString() {
        return this.getId();
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ClientApiKey) {
            ClientApiKey other = (ClientApiKey)o;
            return (this.id != null ? this.id.equals(other.id) : other.id == null) && (this.secret != null ? this.secret.equals(other.secret) : other.secret == null);
        }
        return false;
    }
}

