/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.application;

import com.stormpath.sdk.account.Account;
import com.stormpath.sdk.account.AccountCriteria;
import com.stormpath.sdk.account.AccountList;
import com.stormpath.sdk.account.CreateAccountRequest;
import com.stormpath.sdk.account.PasswordResetToken;
import com.stormpath.sdk.account.VerificationEmailRequest;
import com.stormpath.sdk.api.ApiKey;
import com.stormpath.sdk.api.ApiKeyOptions;
import com.stormpath.sdk.application.AccountStoreHolder;
import com.stormpath.sdk.application.ApplicationAccountStoreMapping;
import com.stormpath.sdk.application.ApplicationAccountStoreMappingCriteria;
import com.stormpath.sdk.application.ApplicationAccountStoreMappingList;
import com.stormpath.sdk.application.ApplicationOptions;
import com.stormpath.sdk.application.ApplicationStatus;
import com.stormpath.sdk.authc.AuthenticationRequest;
import com.stormpath.sdk.authc.AuthenticationResult;
import com.stormpath.sdk.directory.AccountStore;
import com.stormpath.sdk.directory.DirectoryCriteria;
import com.stormpath.sdk.group.CreateGroupRequest;
import com.stormpath.sdk.group.Group;
import com.stormpath.sdk.group.GroupCriteria;
import com.stormpath.sdk.group.GroupList;
import com.stormpath.sdk.idsite.IdSiteCallbackHandler;
import com.stormpath.sdk.idsite.IdSiteUrlBuilder;
import com.stormpath.sdk.oauth.OAuthPolicy;
import com.stormpath.sdk.organization.OrganizationCriteria;
import com.stormpath.sdk.provider.ProviderAccountRequest;
import com.stormpath.sdk.provider.ProviderAccountResult;
import com.stormpath.sdk.resource.Auditable;
import com.stormpath.sdk.resource.Deletable;
import com.stormpath.sdk.resource.Extendable;
import com.stormpath.sdk.resource.Resource;
import com.stormpath.sdk.resource.ResourceException;
import com.stormpath.sdk.resource.Saveable;
import com.stormpath.sdk.saml.SamlCallbackHandler;
import com.stormpath.sdk.saml.SamlIdpUrlBuilder;
import com.stormpath.sdk.saml.SamlPolicy;
import com.stormpath.sdk.tenant.Tenant;
import java.util.List;
import java.util.Map;

public interface Application
extends AccountStoreHolder<Application>,
Resource,
Saveable,
Deletable,
Extendable,
Auditable {
    public String getName();

    public Application setName(String var1);

    public String getDescription();

    public Application setDescription(String var1);

    public ApplicationStatus getStatus();

    public Application setStatus(ApplicationStatus var1);

    public AccountList getAccounts();

    public AccountList getAccounts(Map<String, Object> var1);

    public AccountList getAccounts(AccountCriteria var1);

    public Account createAccount(Account var1) throws ResourceException;

    public Account createAccount(CreateAccountRequest var1) throws ResourceException;

    public GroupList getGroups();

    public GroupList getGroups(Map<String, Object> var1);

    public GroupList getGroups(GroupCriteria var1);

    public Group createGroup(Group var1) throws ResourceException;

    public Group createGroup(CreateGroupRequest var1);

    public Tenant getTenant();

    public PasswordResetToken sendPasswordResetEmail(String var1) throws ResourceException;

    public PasswordResetToken sendPasswordResetEmail(String var1, AccountStore var2) throws ResourceException;

    public Account verifyPasswordResetToken(String var1);

    public Account resetPassword(String var1, String var2);

    public AuthenticationResult authenticateAccount(AuthenticationRequest var1) throws ResourceException;

    public ProviderAccountResult getAccount(ProviderAccountRequest var1);

    public ApplicationAccountStoreMappingList getAccountStoreMappings();

    public ApplicationAccountStoreMappingList getAccountStoreMappings(Map<String, Object> var1);

    public ApplicationAccountStoreMappingList getAccountStoreMappings(ApplicationAccountStoreMappingCriteria var1);

    public ApplicationAccountStoreMapping createAccountStoreMapping(ApplicationAccountStoreMapping var1) throws ResourceException;

    public ApplicationAccountStoreMapping addAccountStore(AccountStore var1) throws ResourceException;

    public ApiKey getApiKey(String var1) throws ResourceException, IllegalArgumentException;

    public ApiKey getApiKey(String var1, ApiKeyOptions var2) throws ResourceException, IllegalArgumentException;

    public IdSiteUrlBuilder newIdSiteUrlBuilder();

    public SamlIdpUrlBuilder newSamlIdpUrlBuilder();

    public IdSiteCallbackHandler newIdSiteCallbackHandler(Object var1);

    public SamlCallbackHandler newSamlCallbackHandler(Object var1);

    public void sendVerificationEmail(VerificationEmailRequest var1);

    public ApplicationAccountStoreMapping addAccountStore(String var1);

    public ApplicationAccountStoreMapping addAccountStore(DirectoryCriteria var1);

    public ApplicationAccountStoreMapping addAccountStore(OrganizationCriteria var1);

    public ApplicationAccountStoreMapping addAccountStore(GroupCriteria var1);

    public Application saveWithResponseOptions(ApplicationOptions var1);

    public OAuthPolicy getOAuthPolicy();

    public SamlPolicy getSamlPolicy();

    public List<String> getAuthorizedCallbackUris();

    public Application setAuthorizedCallbackUris(List<String> var1);

    public Application addAuthorizedCallbackUri(String var1);
}

