/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.model.COSObjectSummary;
import com.qcloud.cos.model.ListObjectsRequest;
import com.qcloud.cos.model.ObjectListing;
import com.qcloud.cos.region.Region;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.List;

public class ListObjectsDemo {
    public static void listObjectsDemo() {
        BasicCOSCredentials cred = new BasicCOSCredentials("AKIDXXXXXXXX", "1A2Z3YYYYYYYYYY");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-beijing-1"));
        COSClient cosclient = new COSClient(cred, clientConfig);
        String bucketName = "mybucket-1251668577";
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest();
        listObjectsRequest.setBucketName(bucketName);
        listObjectsRequest.setPrefix("aaa/bbb");
        listObjectsRequest.setDelimiter("");
        listObjectsRequest.setEncodingType("url");
        listObjectsRequest.setMaxKeys(1000);
        ObjectListing objectListing = null;
        try {
            objectListing = cosclient.listObjects(listObjectsRequest);
        }
        catch (CosServiceException e) {
            e.printStackTrace();
        }
        catch (CosClientException e) {
            e.printStackTrace();
        }
        List<String> commonPrefixs = objectListing.getCommonPrefixes();
        List<COSObjectSummary> cosObjectSummaries = objectListing.getObjectSummaries();
        for (COSObjectSummary cosObjectSummary : cosObjectSummaries) {
            String key = cosObjectSummary.getKey();
            try {
                key = URLDecoder.decode(key, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                continue;
            }
            String etag = cosObjectSummary.getETag();
            long fileSize = cosObjectSummary.getSize();
            String storageClasses = cosObjectSummary.getStorageClass();
        }
        cosclient.shutdown();
    }

    public static void listAllObjects() {
        BasicCOSCredentials cred = new BasicCOSCredentials("AKIDXXXXXXXX", "1A2Z3YYYYYYYYYY");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-beijing-1"));
        COSClient cosclient = new COSClient(cred, clientConfig);
        String bucketName = "mybucket-1251668577";
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest();
        listObjectsRequest.setBucketName(bucketName);
        listObjectsRequest.setPrefix("aaa/bbb");
        listObjectsRequest.setDelimiter("");
        listObjectsRequest.setEncodingType("url");
        listObjectsRequest.setMaxKeys(1000);
        ObjectListing objectListing = null;
        do {
            try {
                objectListing = cosclient.listObjects(listObjectsRequest);
            }
            catch (CosServiceException e) {
                e.printStackTrace();
                return;
            }
            catch (CosClientException e) {
                e.printStackTrace();
                return;
            }
            List<String> commonPrefixs = objectListing.getCommonPrefixes();
            List<COSObjectSummary> cosObjectSummaries = objectListing.getObjectSummaries();
            for (COSObjectSummary cosObjectSummary : cosObjectSummaries) {
                String key = cosObjectSummary.getKey();
                try {
                    key = URLDecoder.decode(key, "utf-8");
                }
                catch (UnsupportedEncodingException e) {
                    continue;
                }
                String etag = cosObjectSummary.getETag();
                long fileSize = cosObjectSummary.getSize();
                String storageClasses = cosObjectSummary.getStorageClass();
            }
        } while (objectListing.isTruncated());
        cosclient.shutdown();
    }
}

