/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.http;

import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.exception.AbstractCosException;
import com.qcloud.cos.exception.ParamException;
import com.qcloud.cos.http.HttpMethod;
import com.qcloud.cos.http.HttpRequest;
import com.qcloud.cos.http.IdleConnectionMonitorThread;
import java.io.InputStream;
import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public abstract class AbstractCosHttpClient {
    protected ClientConfig config;
    protected HttpClient httpClient;
    protected PoolingHttpClientConnectionManager connectionManager;
    protected IdleConnectionMonitorThread idleConnectionMonitor;
    protected RequestConfig requestConfig;

    public AbstractCosHttpClient(ClientConfig config) {
        this.config = config;
        this.connectionManager = new PoolingHttpClientConnectionManager();
        this.connectionManager.setMaxTotal(config.getMaxConnectionsCount());
        this.connectionManager.setDefaultMaxPerRoute(config.getMaxConnectionsCount());
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)this.connectionManager);
        if (config.getHttpProxyIp() != null && config.getHttpProxyPort() != 0) {
            HttpHost proxy = new HttpHost(config.getHttpProxyIp(), config.getHttpProxyPort());
            httpClientBuilder.setProxy(proxy);
        }
        this.httpClient = httpClientBuilder.build();
        this.requestConfig = RequestConfig.custom().setConnectionRequestTimeout(this.config.getConnectionRequestTimeout()).setConnectTimeout(this.config.getConnectionTimeout()).setSocketTimeout(this.config.getSocketTimeout()).build();
        this.idleConnectionMonitor = new IdleConnectionMonitorThread((HttpClientConnectionManager)this.connectionManager);
        this.idleConnectionMonitor.start();
    }

    protected abstract String sendPostRequest(HttpRequest var1) throws AbstractCosException;

    protected abstract String sendGetRequest(HttpRequest var1) throws AbstractCosException;

    public String sendHttpRequest(HttpRequest httpRequest) throws AbstractCosException {
        HttpMethod method = httpRequest.getMethod();
        if (method == HttpMethod.POST) {
            return this.sendPostRequest(httpRequest);
        }
        if (method == HttpMethod.GET) {
            return this.sendGetRequest(httpRequest);
        }
        throw new ParamException("Unsupported Http Method");
    }

    public abstract InputStream getFileInputStream(HttpRequest var1) throws AbstractCosException;

    public void shutdown() {
        this.idleConnectionMonitor.shutdown();
    }
}

