package com.ptteng.util;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.qding.common.util.DataUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.CollectionUtils;

import java.util.*;

public class DynamicUtil {
    private static final Log log = LogFactory.getLog(DynamicUtil.class);

    /**
     * 查询卡券 */
    public static Map<String, Object> getCardListParams(String pwd, Integer status, Long currentTime, Boolean count) {
        Map<String, Object> params = new HashMap<>();

        if (StringUtils.isNotBlank(pwd)) {
            params.put("pwd", " '" + pwd + "' ");
        }

        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("status", status);
        }

        if (DataUtils.isNotNullOrEmpty(currentTime)) {
            params.put("expire_at & >=", currentTime);
        }

        if (count) {
            params.put("@query", "count(id)");
        } else {
            params.put("@query", "id");
        }

        params.put("@table", "card");

        return params;
    }
    /**
     * 查询内容 */
    public static Map<String, Object> getContentListParams(Integer type, Integer status, List<Integer> app, Long cityId,
            Boolean count) {

        Map<String, Object> params = new HashMap<>();

        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put("type", type);
        }

        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("status", status);
        }

        if (DataUtils.isNotNullOrEmpty(cityId)) {
            params.put("city_id", cityId);
        }

        if (!CollectionUtils.isEmpty(app)) {
            String ids = StringUtils.join(app, ",");
            params.put("app & in ", "(" + ids + ")");
        }

        if (count) {
            params.put("@query", " count(id) ");
        } else {
            params.put("@order", "  update_at desc ");
            params.put("@query", " id ");
        }

        params.put("@table", " content ");

        return params;
    }

    /**
     * 查询内容 */
    public static Map<String, Object> getClassListParams(Long cityId) {

        Map<String, Object> params = new HashMap<>();

        params.put("status", 1);
        params.put("city_id", cityId);
        params.put("showcasing", 1);
        params.put("@order", "  update_at desc ");
        params.put("@query", " id ");

        params.put("@table", " driving_class ");

        return params;
    }

    /**
     * 查询某个考点相关的题目 */
    public static Map<String, Object> getSpecialPracticeParams(Integer subjectType, String special, Boolean count) {

        Map<String, Object> params = new HashMap<>();

        if (DataUtils.isNotNullOrEmpty(special)) {
            params.put("examination_point & like ", "'%" + special + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(subjectType)) {
            params.put("subject_type", subjectType);
        }

        if (count) {
            params.put("@query", " count(id) ");
        } else {
            params.put("@query", " id ");
        }

        params.put("@table", " subject_practice ");

        return params;
    }

    /**
     * 查詢城市 */
    public static Map<String, Object> geCenterByCityIdAndStatus(Long cityId, Integer status) {
        Map<String, Object> params = new HashMap<>();
        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("status", status);
        }
        if (DataUtils.isNotNullOrEmpty(cityId)) {
            params.put("city_id ", cityId);
        }

        params.put("@query", " id ");
        params.put("@order", " create_at desc ");
        params.put("@table", " center ");

        return params;
    }

    /**
     * 查詢所有城市 */
    public static Map<String, Object> getCity() {
        Map<String, Object> params = new HashMap<>();
        params.put("@query", " id ");
        params.put("@table", " cities ");

        return params;
    }

    /**
     * 查詢训练场 */
    public static Map<String, Object> getVenuesList(Long cityId) {
        Map<String, Object> params = new HashMap<>();
        if (DataUtils.isNotNullOrEmpty(cityId)) {
            params.put("city_id ", cityId);
        }
        params.put("@query", " id ");
        params.put("@table", " training_venues ");

        return params;
    }

    /**
     * 查詢订单 */
    public static Map<String, Object> getOrderList(Long cityId, Long stuId, Long schoolId, Long classId, String oid,
            Integer status) {
        Map<String, Object> params = new HashMap<>();
        if (DataUtils.isNotNullOrEmpty(cityId)) {
            params.put("city_id ", cityId);
        }
        if (DataUtils.isNotNullOrEmpty(stuId)) {
            params.put("stu_id ", stuId);
        }
        if (DataUtils.isNotNullOrEmpty(schoolId)) {
            params.put("school_id ", schoolId);
        }
        if (DataUtils.isNotNullOrEmpty(classId)) {
            params.put("class_id ", classId);
        }
        if (DataUtils.isNotNullOrEmpty(oid)) {
            params.put("oid ", oid);
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("status ", status);
        }

        params.put("@query", " id ");
        params.put("@table", " orders ");

        return params;
    }


    /**
     * 查询线索 */
    public static Map<String, Object> getStudentClueListParams(String name) {
        Map<String, Object> params = new HashMap<>();

        if (StringUtils.isNotBlank(name)) {
            params.put("name ", name);
        }

        params.put("@query", " id ");

        params.put("@table", " probation");

        return params;
    }

    /**
     * 在指定驾校搜索某个时间范围内发布过的所有考试计划
     * @param schoolId 驾校id
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public synchronized static Map<String, Object> getTestPlanBySchoolIdAndTime(Long schoolId, Integer month)
            throws Exception {

        log.info("schoolId is==" + schoolId + "     month is==" + month);

        Long beginTime;
        Long endTime = null;

        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.MONTH, month - 1);
        int firstDay = calendar.getActualMinimum(Calendar.DAY_OF_MONTH);
        int lastDay = calendar.getActualMaximum(Calendar.DAY_OF_MONTH);

        calendar.set(Calendar.HOUR_OF_DAY, 0);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        calendar.set(Calendar.DAY_OF_MONTH, firstDay);
        beginTime = calendar.getTimeInMillis();

        calendar.set(Calendar.HOUR_OF_DAY, 23);
        calendar.set(Calendar.MINUTE, 59);
        calendar.set(Calendar.SECOND, 59);
        calendar.set(Calendar.DAY_OF_MONTH, lastDay);
        endTime = calendar.getTimeInMillis();

        Map<String, Object> sqlInfo = new HashMap<>();

        //判断是否是unix毫秒级时间
        if (beginTime < 9999999999L || endTime < 9999999999L) {
            log.error("beginTime or endTime is not unix time Of millisecond");
            throw new Exception("beginTime or endTime is not unix time Of millisecond");
        }

        sqlInfo.put("school_id", schoolId);
        sqlInfo.put("1", " 1 and test_time BETWEEN " + beginTime + " AND " + endTime);

        sqlInfo.put("@query", " id");
        sqlInfo.put("@table", "test_plan");

        return sqlInfo;
    }

    /**
     * 根据消息所属事务类型,接收消息目标 ,用户ID查找符合要求的消息 */
    public static Map<String, Object> getUserMessageList(Integer messageType, Integer targetReceive, Long uid,
            Integer status) {
        Map<String, Object> params = new HashMap<>();
        //暂时没有系统消息,所以获得消息不进行区分.
//        params.put("message_type", messageType);

        params.put(" target_receive  ", targetReceive);

        params.put("uid", uid);

        if (status == 1 || status == 2) {
            params.put("status", status);
        }

        params.put("@query", " id ");
        params.put("@order", " create_at desc ");
        params.put("@table", "user_message");

        return params;
    }

    /**
     * 查询教练 */
    public static Map<String, Object> getCoachList(String mobile, Long schoolId, Long cityId, Integer certification) {
        Map<String, Object> params = new HashMap<>();

        if (StringUtils.isNotBlank(mobile)) {
            params.put("mobile & like ", "'%" + mobile + "%'");
        }
        if (DataUtils.isNotNullOrEmpty(schoolId)) {
            params.put("school_id ", schoolId);
        }
        if (DataUtils.isNotNullOrEmpty(cityId)) {
            params.put("city_id ", cityId);
        }
        if (DataUtils.isNotNullOrEmpty(certification)) {
            params.put("certification ", certification);
        }

        params.put("@query", " id ");
        params.put("@table", " coach");

        return params;
    }

    /**
     * 查詢区域时间 */
    public static Map<String, Object> getAppointTimeList(Long coachTimeId, Integer status) {
        Map<String, Object> params = new HashMap<>();
        if (DataUtils.isNotNullOrEmpty(coachTimeId)) {
            params.put("coach_time_id ", coachTimeId);
        }

        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("status ", status);
        }

        params.put("@query", " id ");
        params.put("@table", " advance_time ");

        return params;
    }

    /**
     * 在指定驾校搜索某个时间范围内发布过的所有考试计划
     * @param schoolId 驾校id
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public synchronized static Map<String, Object> getTestPlanIdsByCondition(Long schoolId, List<Long> time)
            throws Exception {

        log.info("schoolId is==" + schoolId + "  time is==" + time);

        Map<String, Object> sqlInfo = new HashMap<>();
        Map<String, Object> parameters = new HashMap<>(16);
        parameters.put("1", time);

        String queryCondition = "";

        for (int i = 1; i < parameters.size() + 1; ++i) {
            String token = i + "";
            if (null == parameters.get(token)) {
                continue;
            }

            switch (token) {
            case "1":
                queryCondition = " and " + getSqlByTimeToGetTestPlan(time);
                break;
            default:
                break;
            }
        }

        sqlInfo.put("school_id", schoolId);
        sqlInfo.put("1", " 1 " + queryCondition);

        sqlInfo.put("@query", " id");
        sqlInfo.put("@table", "test_plan");

        return sqlInfo;
    }

    private static String getSqlByTimeToGetTestPlan(List<Long> time) throws Exception {
        Long startTime = time.get(0);
        Long endTime = time.get(1);

        //unix毫秒级时间一定大于10位数
        if ((null != startTime && startTime < 9999999999L) || (null != endTime && endTime < 9999999999L))
            throw new Exception("beginTime or endTime is not unix time Of millisecond,beginTime is==" + startTime
                    + "   endTime is==" + endTime);

        String sql = null;
        if (null != startTime && null != endTime) {
            sql = "test_time BETWEEN " + startTime + " and " + endTime;
        } else if (null != startTime) {
            sql = "test_time >= " + startTime;
        } else if (null != endTime) {
            sql = "test_time <= " + endTime;
        }

        return sql;
    }

    /**
     * 约车订单搜索 */
    public static Map<String, Object> getAppointOrderList(List<String> type, Long time, Long timeStart, Long timeEnd,
            Long coachId, Long studentId, Integer subject, Long createStart, Long createEnd, Long practiceStart,
            Long practiceEnd) {
        Map<String, Object> params = new HashMap<>();

        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(type)) {
            params.put("type & in ", "(" + String.join(",", type) + ")");
        }

        if (DataUtils.isNotNullOrEmpty(time)) {
            params.put("time ", time);
        }

        if (DataUtils.isNotNullOrEmpty(coachId)) {
            params.put("coach ", coachId);
        }
        if (DataUtils.isNotNullOrEmpty(timeStart)) {
            params.put("time_start ", timeStart);
        }
        if (DataUtils.isNotNullOrEmpty(timeEnd)) {
            params.put("time_end ", timeEnd);
        }
        if (DataUtils.isNotNullOrEmpty(studentId)) {
            params.put("student ", studentId);
        }
        if (DataUtils.isNotNullOrEmpty(subject)) {
            params.put("subject ", subject);
        }

        if (DataUtils.isNotNullOrEmpty(createStart)) {
            params.put("create_at & >=", createStart);
        }

        if (DataUtils.isNotNullOrEmpty(createEnd)) {
            params.put("create_at & <=", createEnd);
        }

        if (DataUtils.isNotNullOrEmpty(practiceStart)) {
            params.put("time & >=", practiceStart);
        }

        if (DataUtils.isNotNullOrEmpty(practiceEnd)) {
            params.put("time & <=", practiceEnd);
        }

        params.put("@query", " id ");
        params.put("@order", " create_at desc ");
        params.put("@table", " appoint_order ");

        return params;
    }

    /**
     * 约车订单搜索 */
    public static Map<String, Object> getAppointOrderListByUpdate(List<String> type, Long coachId) {
        Map<String, Object> params = new HashMap<>();

        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(type)) {
            params.put("type & in ", "(" + String.join(",", type) + ")");
        }

        if (DataUtils.isNotNullOrEmpty(coachId)) {
            params.put("coach ", coachId);
        }


        params.put("@query", " id ");
        params.put("@order", " update_at desc ");
        params.put("@table", " appoint_order ");

        return params;
    }

    /**
     * 查詢教练休息时间 */
    public static Map<String, Object> getCoachFreeList(Long coachId, Long freeTime) {
        Map<String, Object> params = new HashMap<>();

        if (DataUtils.isNotNullOrEmpty(coachId)) {
            params.put("coach_id ", coachId);
        }
        if (DataUtils.isNotNullOrEmpty(freeTime)) {
            params.put("free_time ", freeTime);
        }

        params.put("@query", " id ");
        params.put("@table", " coach_free ");

        return params;
    }

    /**
     * 通过条件获取im即时通讯账号id
     * @param type
     * @param ids
     * @return
     * @throws Exception
     */
    public static Map<String, Object> getImAccountIdByCondition(Integer type, List<Long> ids) throws Exception {

        log.info("type is==" + type + " ids is==" + ids);

        if (null == type || null == ids || 0 == ids.size()) {
            log.info("args is null or size is zero");
            throw new Exception("args can not be null or size is zero");
        }

        Map<String, Object> params = new HashMap<>(16);
        params.put("1", type);
        params.put("2", ids);

        Map<String, Object> sqlInfo = new HashMap<>(16);
        String queryCondition = "";

        for (int i = 1; i < params.size() + 1; ++i) {
            String token = i + "";
            if (null == params.get(token)) {
                continue;
            }

            switch (token) {
            case "1":
                queryCondition = " and " + getSqlByTypeToGetImAccountId(type);
                break;
            case "2":
                queryCondition = queryCondition + " and " + getSqlByIdsToGetImAccountId(ids);
                break;
            default:
                break;
            }
        }

        if (!queryCondition.isEmpty())
            sqlInfo.put("1", " 1 " + queryCondition);

        sqlInfo.put("@query", " id");
        sqlInfo.put("@table", " im_account");

        return sqlInfo;
    }

    private static String getSqlByTypeToGetImAccountId(Integer type) {

        log.info("type is==" + type);

        return "type = " + type;
    }

    private static String getSqlByIdsToGetImAccountId(List<Long> ids) {


        log.info("ids is==" + ids);
        return "target_id in " + listValueToSqlKeyWordINValue(ids);
    }

    public static String listValueToSqlKeyWordINValue(List value) {
        log.info("list value is==" + value);

        String valueSql = "";
        for (int i = 0; i < value.size(); ++i) {
            if (0 == i) {
                valueSql = "(" + value.get(i);
            } else {
                valueSql = valueSql + " ," + value.get(i);
            }

            if (i == value.size() - 1) {
                valueSql = valueSql + ")";
            }
        }

        return valueSql;
    }

    /**
     * 版本搜索 */
    public static Map<String, Object> getPlQuery(Integer os, Integer type) {
        Map<String, Object> params = new HashMap<>();
        params.put(" os  ", os);
        params.put(" type ", type);
        params.put("@query", "id");
        params.put("@table", "version");
        params.put("@order", " create_at desc ");
        return params;
    }


    /**
     * 班型id搜驾校 */
    public static Map<String, Object> classIdgetSchoolList(Long classId) {
        Map<String, Object> params = new HashMap<>();

        if (DataUtils.isNotNullOrEmpty(classId)) {
            params.put("class_id ", classId );
        }


        params.put("@query", "id");
        params.put("@table", "school_class_relation");

        return params;
    }
    /**
     * 驾校id搜索训练场 */
    public static Map<String, Object> schoolIdgetVenuesList(List<String> school) {
        Map<String, Object> params = new HashMap<>();

        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(school)) {
            params.put("school_id & in ", "(" + String.join(",", school) + ")");
        }


        params.put("@query", " id ");
        params.put("@table", " school_venues_relation ");

        return params;
    }


}
