package com.ptteng.controller;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ptteng.util.ParamsUtil;
import com.qding.common.util.DataUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.yi.nucleus.model.StudentFavoriteRelation;
import com.ptteng.yi.nucleus.service.StudentFavoriteRelationService;

/**
 * 学员收藏相关
 *
 * @author zhangxin
 * @Date 2018/01/09
 */
@Controller
public class StudentFavoriteRelationController {
    private static final Log log = LogFactory.getLog(StudentFavoriteRelationController.class);

    @Resource
    private StudentFavoriteRelationService studentFavoriteRelationService;

    /**
     * 添加收藏
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @RequestMapping(value = "/a/u/favorite", method = RequestMethod.POST)
    public String recordFavorite(HttpServletRequest request, HttpServletResponse response, ModelMap model,
            Long studentId, Long targetId, Integer targetType) throws Exception {

        log.info("Interface POST /a/u/favorite, Method recordFavorite() parameters, studentId : " + studentId
                + ", targetId: " + targetId + ", targetType: " + targetType);

        int validateResult = ParamsUtil.checkParamsOfRecordFavorite(studentId, targetId, targetType);
        if (validateResult != ParamsUtil.VALIDATE_RESULT_SUCCESS) {
            model.addAttribute("code", validateResult);
            return "/common/failure";
        }

        try {
            StudentFavoriteRelation studentFavoriteRelation = new StudentFavoriteRelation();
            studentFavoriteRelation.setStudentId(studentId);
            studentFavoriteRelation.setTargetId(targetId);
            studentFavoriteRelation.setTargetType(targetType);
            studentFavoriteRelation.setCreateBy(studentId);
            studentFavoriteRelation.setUpdateBy(studentId);
            Long studentFavoriteRelationId = studentFavoriteRelationService.insert(studentFavoriteRelation);
            log.info("insert studentFavoriteRelation success, studentFavoriteRelation id is : "
                    + studentFavoriteRelationId);

            model.addAttribute("code", 0);
            model.addAttribute("id", studentFavoriteRelationId);
            return "/common/insert";
        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("Method recordFavorite() failed, parameters, studentId : " + studentId + ", targetId: " + targetId
                    + ", targetType: " + targetType);
            model.addAttribute("code", -1);
            return "/common/failure";
        }
    }

    /**
     * 删除收藏
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @RequestMapping(value = "/a/u/favorite", method = RequestMethod.DELETE)
    public String removeFavorite(HttpServletRequest request, HttpServletResponse response, ModelMap model,
            Long studentId, Long targetId) throws Exception {

        log.info("Interface DELETE /a/u/favorite, Method recordFavorite() parameters, studentId : " + studentId
                + ", targetId: " + targetId);

        int validateResult = ParamsUtil.checkParamsOfRemoveFavorite(studentId, targetId);
        if (validateResult != ParamsUtil.VALIDATE_RESULT_SUCCESS) {
            model.addAttribute("code", validateResult);
            return "/common/failure";
        }

        try {
            Long studentFavoriteRelationId = studentFavoriteRelationService
                    .getStudentFavoriteRelationIdByStudentIdAndTargetId(studentId, targetId);
            if (DataUtils.isNullOrEmpty(studentFavoriteRelationId)) {
                log.info("Can not find studentFavoriteRelation by studentId,targetId: " + studentId + ", " + targetId);
                model.addAttribute("code", -1001);
                return "/common/failure";
            }
            log.info("get studentFavoriteRelation id by studentId,targetId, id is : " + studentFavoriteRelationId);

            studentFavoriteRelationService.delete(studentFavoriteRelationId);
            log.info("delete student favorite success");

            model.addAttribute("code", 0);
            return "/common/success";
        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error(
                    "Method recordFavorite() parameters failed , studentId : " + studentId + ", targetId: " + targetId);
            model.addAttribute("code", -1);
            return "/common/failure";
        }
    }
}
