package com.ptteng.controller;

import java.util.ArrayList;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ptteng.yi.nucleus.service.StudentsService;
import com.ptteng.yi.pub.service.CitiesService;
import com.qding.common.util.DataUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.yi.pub.model.Info;
import com.ptteng.yi.pub.service.InfoService;

/**
 * Info  crud
 * 
 * @author wangmeng
 * @Date 2017-12-25 13:43
 * 
 */
@Controller
public class InfoController {
    private static final Log log = LogFactory.getLog(InfoController.class);

    @Autowired
    private InfoService infoService;

    @Autowired
    private CitiesService citiesService;

    /**
     * 查看信息详情
     * @param request
     * @param response
     * @param model
     * @param id
     * @return
     * @throws Exception*/

    @RequestMapping(value = "/a/info/{id}", method = RequestMethod.GET)
    public String getInfoJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
            @PathVariable Long id) throws Exception {

        log.info("GET request url : /a/info/{id}, get path variable id : " + id);

        //        Students student = (Students) request.getAttribute("user");
        //        Long sid = student.getId();

        try {
            Info info = infoService.getObjectById(id);
            log.info("get info data is " + info);

            if (DataUtils.isNullOrEmpty(info)) {
                log.info("no this info");
                model.addAttribute("code", -13000);
                return "/common/failure";
            }

            //            Students student1 = studentsService.getObjectById(sid);
            //
            //            if (student1.getRegistrationDate() == null){
            //                if (info.getType() == Info.TYPE_AFTER_SERVICE){
            //                    log.info("no permission selecting this type info");
            //                    model.addAttribute("code", -13004);
            //                    return "/common/failure";
            //                }
            //            }

            model.addAttribute("code", 0);

            model.addAttribute("info", info);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get info error, id is  " + id);
            model.addAttribute("code", -100000);
        }

        return "/yi-pub-service/info/json/infoDetailJson";
    }

    /**
     * 获取信息列表
     * @param request
     * @param response
     * @param model
     * @param type 类型
     * @param cityId 城市id
     * @param page
     * @param size
     * @return
     * @throws Exception*/

    @RequestMapping(value = "/a/info/list", method = RequestMethod.GET)
    public String getMultiInfoJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
            Integer type, Long cityId, Integer page, Integer size) throws Exception {

        log.info("GET request url: /a/info/list, get parameter type: " + type + ", cityId: " + cityId + ", page: "
                + page + ", size: " + size);

        //        Students student = (Students) request.getAttribute("user");
        //        Long sid = student.getId();

        if (DataUtils.isNullOrEmpty(type)) {
            log.info("parameter type is null or empty");
            model.addAttribute("code", -13002);
            return "/common/failure";
        }

        if (type < Info.TYPE_ENROLLMENT_NOTICE || type > Info.TYPE_AFTER_SERVICE) {
            log.info("parameter type is illegal");
            model.addAttribute("code", -13003);
            return "/common/failure";
        }

        if (DataUtils.isNullOrEmpty(cityId)) {
            log.info("parameter cityId is null or empty");
            model.addAttribute("code", -13005);
            return "/common/failure";
        }

        if (cityId < 1L) {
            log.info("parameter cityId is illegal");
            model.addAttribute("code", -13006);
            return "/common/failure";
        }

        if (page == null) {
            page = 1;
        }
        if (size == null || size < 0) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        log.info("pageList : page= " + start + " , size=" + size);

        try {
            List<Long> cityIds = citiesService.getCitiesIdsByCityid(cityId, 0, Integer.MAX_VALUE);

            if (CollectionUtils.isEmpty(cityIds)) {
                log.info("there is no city in DB");
                model.addAttribute("code", -12003);
                return "/common/failure";
            }

            List<Long> infoIds = infoService.getInfoIdsByTypeAndStatusAndCityId(type, Info.STATUS_ONLINE, cityId, start,
                    size);
            log.info("get info id list : " + infoIds);

            Integer total = infoService
                    .getInfoIdsByTypeAndStatusAndCityId(type, Info.STATUS_ONLINE, cityId, 0, Integer.MAX_VALUE).size();

            if (CollectionUtils.isEmpty(infoIds)) {
                model.addAttribute("infoList", new ArrayList());
            } else {
                List<Info> infoList = infoService.getObjectsByIds(infoIds);
                log.info("get infoList data size is " + infoList.size());

                model.addAttribute("infoList", infoList);
            }

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("total", total);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get info list error, start is  " + start + " , size " + size);
            model.addAttribute("code", -100000);
        }

        return "/yi-pub-service/info/json/infoListJson";
    }
}
