package com.ptteng.controller;

import com.ptteng.util.DynamicUtil;
import com.ptteng.yi.nucleus.model.DrivingClass;
import com.ptteng.yi.nucleus.service.DrivingClassService;
import com.ptteng.yi.nucleus.service.SchoolClassRelationService;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * DrivingClass  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class DrivingClassController {
	private static final Log log = LogFactory.getLog(DrivingClassController.class);

	@Autowired
	private DrivingClassService drivingClassService;
	@Autowired
	private CookieUtil cookieUtil;
	@Autowired
	private SchoolClassRelationService schoolClassRelationService;

	/**
	 * 获取班级列表
	 * @param request
	 * @param page
	 * @param size
	 * @param response
	 * @param model
	 * @param cityId
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/class/list ", method = RequestMethod.GET)
	public String getDrivingClassIdsByStatusOrderByCreateByJsonList(HttpServletRequest request, Integer page,
			Integer size, HttpServletResponse response, ModelMap model, Long cityId) throws Exception {
		if (page == null) {
			page = 1;
		}
		if (size == null || size < 0) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}
		try {
			if (DataUtils.isNullOrEmpty(cityId)) {
				model.addAttribute("code", -1000);
				log.info("parameter classes is null or empty");
				return "/common/failure";
			}

			Map<String, Object> map = DynamicUtil.getClassListParams(cityId);
			log.info("get query news list map : " + map);

			List<Long> ids = drivingClassService.getIdsByDynamicCondition(DrivingClass.class, map, start, size);

			Integer total = drivingClassService.getIdsByDynamicCondition(DrivingClass.class, map, 0, Integer.MAX_VALUE)
					.size();

			List<DrivingClass> classList = drivingClassService.getObjectsByIds(ids);
			model.addAttribute("code", 0);
			model.addAttribute("total", total);
			model.addAttribute("drivingClassList", classList);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			// for test
			model.addAttribute("code", -100000);
		}

		return "/yi-nucleus-service/drivingClass/json/drivingClassListJson";
	}

	/**
	 * 获取班级详情
	 * @param request
	 * @param response
	 * @param model
	 * @param id
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/class/{id}", method = RequestMethod.GET)
	public String getDrivingClassJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
			@PathVariable Long id) throws Exception {

		log.info("get data : id= " + id);
		try {

			DrivingClass drivingClass = drivingClassService.getObjectById(id);
			log.info("get drivingClass data is " + drivingClass);
			if (DataUtils.isNullOrEmpty(drivingClass)) {
				model.addAttribute("code", -21013);
				log.info("parameter classes is null or empty");
				return "/common/failure";
			}

			model.addAttribute("code", 0);

			model.addAttribute("drivingClass", drivingClass);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get drivingClass error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/yi-nucleus-service/drivingClass/json/drivingClassDetailJson";
	}
	//
	//	@RequestMapping(value = "/a/u/class/{id}", method = RequestMethod.PUT)
	//	public String updateDrivingClassJson(HttpServletRequest request,
	//			HttpServletResponse response, ModelMap model, DrivingClass drivingClass) throws Exception {
	//
	//		log.info("update drivingClass : drivingClass= " + drivingClass);
	//
	//		try {
	//
	//			drivingClassService.update(drivingClass);
	//
	//			model.addAttribute("code", 0);
	//
	//			model.addAttribute("drivingClass", drivingClass);
	//
	//		} catch (Throwable t) {
	//		    t.printStackTrace();
	//			log.error(t.getMessage());
	//			log.error("update drivingClass error,id is  " + drivingClass.getId());
	//			model.addAttribute("code", -6003);
	//
	//		}
	//
	//		return "/data/json";
	//	}
	//
	//	@RequestMapping(value = "/a/u/class", method = RequestMethod.POST)
	//	public String addDrivingClassJson(HttpServletRequest request,
	//			HttpServletResponse response, ModelMap model, DrivingClass drivingClass) throws Exception {
	//
	//		log.info("update drivingClass : drivingClass= " + drivingClass);
	//
	//		try {
	//
	//			Long mid = Long.valueOf(cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID));
	//			log.info(mid);
	//			//城市
	//			if (DataUtils.isNullOrEmpty(drivingClass.getCityId())){
	//				model.addAttribute("code",-1000);
	//				log.info("parameter classes is null or empty");
	//				return "/common/failure";
	//			}
	//			//服务承诺
	//			if (DataUtils.isNullOrEmpty(drivingClass.getCommitment())){
	//				model.addAttribute("code",-1000);
	//				log.info("parameter classes is null or empty");
	//				return "/common/failure";
	//			}
	//			//班名
	//			if (DataUtils.isNullOrEmpty(drivingClass.getName())){
	//				model.addAttribute("code",-1000);
	//				log.info("parameter classes is null or empty");
	//				return "/common/failure";
	//			}
	//			//费用
	//			if (DataUtils.isNullOrEmpty(drivingClass.getCost())){
	//				model.addAttribute("code",-1000);
	//				log.info("parameter classes is null or empty");
	//				return "/common/failure";
	//			}
	//			//费用明细
	//			if (DataUtils.isNullOrEmpty(drivingClass.getCostDetail())){
	//				model.addAttribute("code",-1000);
	//				log.info("parameter classes is null or empty");
	//				return "/common/failure";
	//			}
	//			//车型
	//			if (DataUtils.isNullOrEmpty(drivingClass.getCar())){
	//				model.addAttribute("code",-1000);
	//				log.info("parameter classes is null or empty");
	//				return "/common/failure";
	//			}
	//			//详情图片
	//			if (DataUtils.isNullOrEmpty(drivingClass.getDetailImg())){
	//				model.addAttribute("code",-1000);
	//				log.info("parameter classes is null or empty");
	//				return "/common/failure";
	//			}
	//			//科三课时
	//			if (DataUtils.isNullOrEmpty(drivingClass.getSubjectThreeHour())){
	//				model.addAttribute("code",-1000);
	//				log.info("parameter classes is null or empty");
	//				return "/common/failure";
	//			}
	//			//科三人数
	//			if (DataUtils.isNullOrEmpty(drivingClass.getSubjectThreeNumbers())){
	//				model.addAttribute("code",-1000);
	//				log.info("parameter classes is null or empty");
	//				return "/common/failure";
	//			}
	//			//科二课时
	//			if (DataUtils.isNullOrEmpty(drivingClass.getSubjectTwoHour())){
	//				model.addAttribute("code",-1000);
	//				log.info("parameter classes is null or empty");
	//				return "/common/failure";
	//			}
	//			//科二人数
	//			if (DataUtils.isNullOrEmpty(drivingClass.getSubjectTwoNumbers())){
	//				model.addAttribute("code",-1000);
	//				log.info("parameter classes is null or empty");
	//				return "/common/failure";
	//			}
	//			//班型描述
	//			if (DataUtils.isNullOrEmpty(drivingClass.getIntro())){
	//				model.addAttribute("code",-1000);
	//				log.info("parameter classes is null or empty");
	//				return "/common/failure";
	//			}
	//			//列表图片
	//			if (DataUtils.isNullOrEmpty(drivingClass.getListImg())){
	//				model.addAttribute("code",-1000);
	//				log.info("parameter classes is null or empty");
	//				return "/common/failure";
	//			}
	//			drivingClass.setCreateBy(mid);
	//			drivingClass.setUpdateBy(mid);
	//			drivingClassService.insert(drivingClass);
	//
	//			model.addAttribute("code", 0);
	//		} catch (Throwable t) {
	//		    t.printStackTrace();
	//			log.error(t.getMessage());
	//			log.error("add drivingClass error ");
	//			model.addAttribute("code", -6002);
	//		}
	//
	//		return "/data/json";
	//	}
	//
	//	@RequestMapping(value = "/a/u/class/{id}", method = RequestMethod.DELETE)
	//	public String deleteDrivingClassJson(HttpServletRequest request,
	//			HttpServletResponse response, ModelMap model, @PathVariable Long id)
	//			throws Exception {
	//
	//		log.info("delete drivingClass : id= " + id);
	//		try {
	//			drivingClassService.delete(id);
	//
	//			log.info("add drivingClass success");
	//			model.addAttribute("code", 0);
	//
	//		} catch (Throwable t) {
	//		    t.printStackTrace();
	//			log.error(t.getMessage());
	//			log.error("delete drivingClass error,id is  " + id);
	//			model.addAttribute("code", -6004);
	//
	//		}
	//
	//		return "/data/json";
	//	}
	//
	//
	//	@RequestMapping(value = "/a/u/multi/drivingClass", method = RequestMethod.GET)
	//	public String getMultiDrivingClassJson(HttpServletRequest request,
	//			HttpServletResponse response, ModelMap model, Long[] ids)
	//			throws Exception {
	//
	//		List<Long> idList = new ArrayList();
	//	   if (ids == null) {
	//
	//		} else {
	//			idList = Arrays.asList(ids);
	//		}
	//		try {
	//
	//
	//			List<DrivingClass> drivingClassList = drivingClassService.getObjectsByIds(idList);
	//			log.info("get  drivingClass data is " + drivingClassList);
	//
	//			model.addAttribute("code", 0);
	//			model.addAttribute("total",drivingClassList.size());
	//
	//			model.addAttribute("drivingClassList", drivingClassList);
	//
	//		} catch (Throwable t) {
	//			log.error(t.getMessage());
	//			log.error("get drivingClass error,id is  " + idList);
	//			model.addAttribute("code", -100000);
	//		}
	//
	//		return "/yi-nucleus-service/drivingClass/json/drivingClassListJson";
	//	}
	//

}
