/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.xqlease.etl.etl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.xqlease.common.model.Bill;
import com.ptteng.xqlease.common.model.BillLog;
import com.ptteng.xqlease.common.model.TradingFlow;
import com.ptteng.xqlease.common.model.User;
import com.ptteng.xqlease.common.service.BillLogService;
import com.ptteng.xqlease.common.service.BillService;
import com.ptteng.xqlease.common.service.TradingFlowService;
import com.ptteng.xqlease.common.service.UserService;
import com.ptteng.xqlease.etl.util.NumberingUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RentBillStatusEtl {
    Log log = LogFactory.getLog(RentBillStatusEtl.class);
    private static final long ONE_DAY_TO_MILLISECONDS = 86400000L;
    private long interval = 86400000L;
    private BillService billService;
    private BillLogService billLogService;
    private UserService userService;
    private TradingFlowService tradingFlowService;

    public BillService getBillService() {
        return this.billService;
    }

    public void setBillService(BillService billService) {
        this.billService = billService;
    }

    public BillLogService getBillLogService() {
        return this.billLogService;
    }

    public void setBillLogService(BillLogService billLogService) {
        this.billLogService = billLogService;
    }

    public UserService getUserService() {
        return this.userService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public TradingFlowService getTradingFlowService() {
        return this.tradingFlowService;
    }

    public void setTradingFlowService(TradingFlowService tradingFlowService) {
        this.tradingFlowService = tradingFlowService;
    }

    public Long getInterval() {
        return this.interval;
    }

    public void setInterval(Long interval) {
        this.interval = interval;
    }

    public void process() throws InterruptedException, ServiceException, ServiceDaoException {
        this.log.info((Object)"process===============");
        try {
            List<Bill> billList = this.getNeedGenerateBill();
            if (CollectionUtils.isNotEmpty(billList)) {
                this.log.info((Object)("billList============" + billList.size()));
                this.changeBillsGerateStatus(billList);
                this.updateBill(billList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateBill(List<Bill> billList) throws ServiceException, ServiceDaoException {
        this.log.info((Object)("deductFee======billList=============" + billList.size()));
        ArrayList<Bill> updateBillList = new ArrayList<Bill>();
        ArrayList<BillLog> billLogList = new ArrayList<BillLog>();
        for (Bill bill : billList) {
            this.log.info((Object)("bill here=====" + bill));
            User user = this.userService.getObjectById(bill.getUid());
            this.log.info((Object)("user===========" + user));
            if (user.getBalance().compareTo(bill.getTotalFee()) >= 0) {
                this.deductBalance(user, bill);
                bill.setPayAccount(user.getMobile());
                bill.setPayStatus(Integer.valueOf(2));
                bill.setPayMethod(Integer.valueOf(1));
                bill.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
                bill.setUpdateBy(Long.valueOf(1L));
                updateBillList.add(bill);
                BillLog billLog = new BillLog();
                billLog.setBillLogType(Integer.valueOf(2));
                billLog.setBid(bill.getId());
                billLog.setRemark("");
                billLog.setCreateBy(Long.valueOf(1L));
                billLog.setUpdateBy(Long.valueOf(1L));
                billLogList.add(billLog);
                continue;
            }
            this.log.info((Object)"account do not have enough money===========");
        }
        this.log.info((Object)("updateBillList========" + updateBillList.size()));
        this.log.info((Object)("billLogList========" + billLogList.size()));
        if (CollectionUtils.isNotEmpty(updateBillList)) {
            this.log.info((Object)"do updateBillList=======");
            this.billService.updateList(updateBillList);
        }
        if (CollectionUtils.isNotEmpty(billLogList)) {
            this.log.info((Object)"do insert billLogList=======");
            this.billLogService.insertList(billLogList);
        }
    }

    private void deductBalance(User user, Bill bill) throws ServiceException, ServiceDaoException {
        this.log.info((Object)("deductBalance========" + bill.getTotalFee()));
        user.setBalance(user.getBalance().subtract(bill.getTotalFee()));
        this.userService.update(user);
        TradingFlow balanceTradingFlow = new TradingFlow();
        balanceTradingFlow.setUid(user.getId());
        balanceTradingFlow.setSerialNum(NumberingUtil.getNumbering(3));
        balanceTradingFlow.setRecordType(TradingFlow.TRANSACTION_TYPE_BILL_PAYMENT);
        balanceTradingFlow.setTransactionAmount(bill.getTotalFee());
        balanceTradingFlow.setTransactionTime(Long.valueOf(System.currentTimeMillis()));
        balanceTradingFlow.setCreateBy(Long.valueOf(1L));
        balanceTradingFlow.setUpdateBy(Long.valueOf(1L));
        balanceTradingFlow.setTradingSort(TradingFlow.TRADING_SORT_BALANCE);
        balanceTradingFlow.setTransactionType(TradingFlow.RECORD_TYPE_EXPENDITURE);
        balanceTradingFlow.setOrdersNum(bill.getBillNum());
        balanceTradingFlow.setBalance(user.getBalance().subtract(bill.getTotalFee()));
        balanceTradingFlow.setDeviceSerialNum(bill.getDeviceSerialNum());
        balanceTradingFlow.setGoodsName("");
        Long balanceTradingFlowId = this.tradingFlowService.insert(balanceTradingFlow);
        this.log.info((Object)("balanceTradingFlowId===============" + balanceTradingFlowId));
    }

    private void changeBillsGerateStatus(List<Bill> billList) throws ServiceException, ServiceDaoException {
        this.log.info((Object)("changeBillsGerateStatus===========" + billList.size()));
        ArrayList<BillLog> billLogList = new ArrayList<BillLog>();
        for (int i = 0; i < billList.size(); ++i) {
            billList.get(i).setBillCreateStatus(Integer.valueOf(2));
            billList.get(i).setUpdateBy(Long.valueOf(1L));
            BillLog billLog = new BillLog();
            billLog.setBillLogType(Integer.valueOf(1));
            billLog.setBid(billList.get(i).getId());
            billLog.setRemark("");
            billLog.setCreateBy(Long.valueOf(1L));
            billLog.setUpdateBy(Long.valueOf(1L));
            billLogList.add(billLog);
        }
        this.billService.updateList(billList);
        this.billLogService.insertList(billLogList);
    }

    public List<Bill> getNeedGenerateBill() throws ServiceException, ServiceDaoException {
        this.log.info((Object)"getNeedGenerateBill============");
        List<Object> needGenerateBill = new ArrayList<Bill>();
        HashMap<String, Object> needGenerateBillParam = new HashMap<String, Object>();
        needGenerateBillParam.put("@table", "bill");
        needGenerateBillParam.put("bill_type", 10);
        needGenerateBillParam.put("bill_create_status", 1);
        needGenerateBillParam.put("period_start & <= ", System.currentTimeMillis());
        List billIdList = this.billService.getIdsByDynamicCondition(Bill.class, needGenerateBillParam, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
        this.log.info((Object)("billIdList===========" + billIdList));
        if (CollectionUtils.isNotEmpty((Collection)billIdList)) {
            needGenerateBill = this.billService.getObjectsByIds(billIdList);
            this.log.info((Object)("needGenerateBill=========" + needGenerateBill.size()));
        }
        return needGenerateBill;
    }
}

