/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.xqlease.etl.util;

import com.ptteng.common.dao.util.SQLUtil;
import com.ptteng.xqlease.common.model.SaledOrders;
import com.qding.common.util.DataUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DynamicUtil {
    private static final Log log = LogFactory.getLog(DynamicUtil.class);

    public static Map<String, Object> getUserList(String mobile, Long startAt, Long endAt, Integer status, boolean count) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (DataUtils.isNotNullOrEmpty((Object)mobile)) {
            map.put("mobile & like ", "'%" + mobile + "%'");
        }
        if (DataUtils.isNotNullOrEmpty((Object)startAt)) {
            map.put("create_at & >= ", startAt);
        }
        if (DataUtils.isNotNullOrEmpty((Object)endAt)) {
            map.put("create_at &  <= ", endAt);
        }
        if (DataUtils.isNotNullOrEmpty((Object)status)) {
            map.put("status", status);
        }
        if (count) {
            map.put("@query", "count(id)");
        } else {
            map.put("@order", "create_at desc");
            map.put("@query", "id");
        }
        map.put("@table", "user");
        return map;
    }

    public static Map<String, Object> getContentsQueryListParam(Integer[] type, Integer status, String title, Long createBy, Long createStartAt, Long createEndAt, Long publishStartAt, Long publishEndAt, boolean isCount) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (DataUtils.isNotNullOrEmpty((Object)type)) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            if (type != null) {
                for (Integer t : type) {
                    if (t == null) continue;
                    sb.append(t.toString());
                    sb.append(",");
                    ++i;
                }
            }
            sb.deleteCharAt(sb.length() - 1);
            params.put("type & in ", "(" + sb.toString() + ")");
        }
        if (DataUtils.isNotNullOrEmpty((Object)status)) {
            params.put("status", status);
        }
        if (DataUtils.isNotNullOrEmpty((Object)title)) {
            params.put("title", "'" + title + "'");
        }
        if (DataUtils.isNotNullOrEmpty((Object)createBy)) {
            params.put("create_by", createBy);
        }
        if (DataUtils.isNotNullOrEmpty((Object)createStartAt)) {
            params.put("create_at & >=", createStartAt);
        }
        if (DataUtils.isNotNullOrEmpty((Object)createEndAt)) {
            params.put("create_at & <=", createEndAt);
        }
        if (DataUtils.isNotNullOrEmpty((Object)publishStartAt)) {
            params.put("publish_at & >=", publishStartAt);
        }
        if (DataUtils.isNotNullOrEmpty((Object)publishEndAt)) {
            params.put("publish_at & <=", publishEndAt);
        }
        if (isCount) {
            params.put("@query", "count(id) ");
        } else {
            params.put("@order", "update_at desc ");
            params.put("@query", "id ");
        }
        params.put("@table", "contents ");
        return params;
    }

    public static Map<String, Object> getArticleListParam(String title, String url, String content, Integer status, Integer type, Integer bannerType) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashSet<String> tables = new HashSet<String>();
        tables.add("article");
        if (DataUtils.isNotNullOrEmpty((Object)type)) {
            params.put(" article.type", type);
        } else {
            params.put(" (article.type ", " 1 or type = 2)");
        }
        if (DataUtils.isNotNullOrEmpty((Object)bannerType)) {
            params.put(" article.banner_type", bannerType);
        }
        if (DataUtils.isNotNullOrEmpty((Object)content)) {
            params.put(" article.content & like", " '%" + content + "%'");
        }
        if (DataUtils.isNotNullOrEmpty((Object)title)) {
            params.put(" article.title & like", " '%" + title + "%'");
        }
        if (DataUtils.isNotNullOrEmpty((Object)url)) {
            params.put(" article.url & like", " '%" + url + "%'");
        }
        if (DataUtils.isNotNullOrEmpty((Object)status)) {
            params.put(" article.status ", status);
        }
        params.put("@order", "  orderBy asc , create_at desc ");
        params.put("@query", " id ");
        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);
        return params;
    }

    public static Map<String, Object> getConstantListParam(String type, String name, String value, String comments, Long startAt, Long endAt, Long id, Long updateStartAt, Long updateEndAt, boolean count) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashSet<String> tables = new HashSet<String>();
        log.info((Object)"start select from constant");
        tables.add("constant");
        if (DataUtils.isNotNullOrEmpty((Object)type)) {
            params.put(" type & like ", "'%" + type + "%'");
        }
        if (DataUtils.isNotNullOrEmpty((Object)name)) {
            params.put(" name & like ", "'%" + name + "%'");
        }
        if (DataUtils.isNotNullOrEmpty((Object)value)) {
            params.put(" value & like ", "'%" + value + "%'");
        }
        if (DataUtils.isNotNullOrEmpty((Object)comments)) {
            params.put(" comments & like ", "'%" + comments + "%'");
        }
        if (DataUtils.isNotNullOrEmpty((Object)startAt)) {
            params.put("create_at & >= ", startAt);
        }
        if (DataUtils.isNotNullOrEmpty((Object)endAt)) {
            params.put("create_at &  <= ", endAt);
        }
        if (DataUtils.isNotNullOrEmpty((Object)updateStartAt)) {
            params.put("update_at & >= ", updateStartAt);
        }
        if (DataUtils.isNotNullOrEmpty((Object)updateEndAt)) {
            params.put("update_at &  <= ", updateEndAt);
        }
        if (DataUtils.isNotNullOrEmpty((Object)id)) {
            params.put("id", id);
        }
        if (count) {
            params.put("@query", " count(id) ");
        } else {
            params.put("@order", " update_at desc  ");
            params.put("@query", " id ");
        }
        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);
        return params;
    }

    public static Map<String, Object> getUserMessage(Integer uid, Integer status, Long messageId, Integer type) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (DataUtils.isNotNullOrEmpty((Object)uid)) {
            params.put("uid", uid);
        }
        if (DataUtils.isNotNullOrEmpty((Object)status)) {
            params.put("status", status);
        }
        if (DataUtils.isNotNullOrEmpty((Object)messageId)) {
            params.put("message_id", messageId);
        }
        if (DataUtils.isNotNullOrEmpty((Object)type)) {
            params.put("type", type);
        }
        params.put("@query", "id");
        params.put("@table", "userMessage");
        return params;
    }

    public static Map<String, Object> getMessageList(String title, Integer status, Long createBy, Long startAt, Long endAt, Integer personType, boolean count) {
        HashedMap params = new HashedMap();
        HashSet<String> tables = new HashSet<String>();
        tables.add("message");
        if (DataUtils.isNotNullOrEmpty((Object)title)) {
            params.put("message.title & like", " '%" + title + "%'");
        }
        if (DataUtils.isNotNullOrEmpty((Object)status)) {
            params.put("message.status ", " '" + status + "'");
        }
        if (DataUtils.isNotNullOrEmpty((Object)personType)) {
            params.put("message.person_type ", " '" + personType + "'");
        } else {
            params.put("message.person_type & in ", "(1,2,3,4,5)");
        }
        if (DataUtils.isNotNullOrEmpty((Object)endAt)) {
            params.put("message.update_at & <= ", " '" + endAt + "'");
        }
        if (DataUtils.isNotNullOrEmpty((Object)startAt)) {
            params.put("message.update_at & >= ", " '" + startAt + "'");
        }
        if (DataUtils.isNotNullOrEmpty((Object)createBy)) {
            params.put("create_by", createBy);
        }
        if (count) {
            params.put("@query", " count(message.id) ");
        } else {
            params.put("@order", "  message.update_at desc  ");
            params.put("@query", " message.id ");
        }
        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);
        return params;
    }

    public static Map<String, Object> getGoodsSkuRentFeePeriodList(List<String> goodsSkuRentFeePeriod, boolean count) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (DataUtils.isNotNullOrEmpty(goodsSkuRentFeePeriod)) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            if (goodsSkuRentFeePeriod != null) {
                for (String t : goodsSkuRentFeePeriod) {
                    if (t == null) continue;
                    sb.append(t);
                    sb.append(",");
                    ++i;
                }
            }
            sb.deleteCharAt(sb.length() - 1);
            params.put("sku_id_period & in ", "(" + sb.toString() + ")");
        }
        if (count) {
            params.put("@query", "count(id) ");
        } else {
            params.put("@order", "update_at desc ");
            params.put("@query", "id ");
        }
        params.put("@table", "goods_sku_rent_fee_period ");
        return params;
    }

    public static Map<String, Object> getTradingFlowList(Integer recordType, Integer tradingSort, boolean count) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (DataUtils.isNotNullOrEmpty((Object)recordType)) {
            map.put("record_type", recordType);
        }
        if (DataUtils.isNotNullOrEmpty((Object)tradingSort)) {
            map.put("trading_sort", tradingSort);
        }
        if (count) {
            map.put("@query", "count(id)");
        } else {
            map.put("@order", "create_at desc");
            map.put("@query", "id");
        }
        map.put("@table", "trading_flow");
        return map;
    }

    public static Map<String, Object> getUidByOpenidAnType(String openIdWx) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (DataUtils.isNotNullOrEmpty((Object)openIdWx)) {
            params.put("openid", openIdWx);
        }
        params.put("@order", "create_at desc");
        params.put("@query", " id");
        params.put("@table", " user");
        return params;
    }

    public static Map<String, Object> getUidByUnionid(String openid) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (DataUtils.isNotNullOrEmpty((Object)openid)) {
            params.put("openid", openid);
        }
        params.put("@order", "  create_at desc ");
        params.put("@query", "id");
        params.put("@table", "user");
        return params;
    }

    public static Map<String, Object> getGoodsSkuRentPeriodBySkuIdList(List<Long> skuIds) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (DataUtils.isNotNullOrEmpty(skuIds)) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Long i : skuIds) {
                stringBuilder.append(i).append(",");
            }
            stringBuilder.deleteCharAt(stringBuilder.lastIndexOf(","));
            stringBuilder.append(")");
            params.put("sku_id & in (", stringBuilder);
        }
        params.put("@query", "id");
        params.put("@table", "goods_sku_rent_fee_period");
        params.put("@order", "sku_id desc ");
        return params;
    }

    public static Map<String, Object> getGoodsSkuPayModeBySkuIdList(List<Long> skuIds) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (DataUtils.isNotNullOrEmpty(skuIds)) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Long i : skuIds) {
                stringBuilder.append(i).append(",");
            }
            stringBuilder.deleteCharAt(stringBuilder.lastIndexOf(","));
            stringBuilder.append(")");
            params.put("sku_id & in (", stringBuilder);
        }
        params.put("@query", "id");
        params.put("@table", "goods_sku_pay_mode_relation");
        params.put("@order", "sku_id desc ");
        return params;
    }

    public static Map<String, Object> getTopicGoodsByTopicIdsAndShelfStatus(List<Long> topicIdList, Integer shelfStatus) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (DataUtils.isNotNullOrEmpty(topicIdList)) {
            if (topicIdList.size() == 0) {
                params.put("goods_sort_id & in (", "null)");
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                for (Long i : topicIdList) {
                    stringBuilder.append(i).append(",");
                }
                stringBuilder.deleteCharAt(stringBuilder.lastIndexOf(","));
                stringBuilder.append(")");
                params.put("topic_id & in (", stringBuilder);
            }
        }
        if (DataUtils.isNotNullOrEmpty((Object)shelfStatus)) {
            params.put("shelf_status", shelfStatus);
        }
        params.put("@query", "id");
        params.put("@table", "topic_goods");
        params.put("@order", "topic_id,sort asc,update_at desc");
        return params;
    }

    public static Map<String, Object> getGoodsDynamic(String searchWord, Long brandId, Long goodsSortId, BigDecimal startPrice, BigDecimal endPrice, Integer sortMode, Integer shelfStatus, Integer shortPeriodStatus, boolean count) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (DataUtils.isNotNullOrEmpty((Object)searchWord)) {
            String[] str;
            for (String s : str = searchWord.split(" ")) {
                params.put("goods_name & like", " '%" + s + "%'");
            }
        }
        if (DataUtils.isNotNullOrEmpty((Object)brandId)) {
            params.put("brand_id", brandId);
        }
        if (DataUtils.isNotNullOrEmpty((Object)goodsSortId)) {
            params.put("goods_sort_id", goodsSortId);
        }
        if (DataUtils.isNotNullOrEmpty((Object)startPrice)) {
            params.put("lowest_rent_fee & >=", startPrice);
        }
        if (DataUtils.isNotNullOrEmpty((Object)endPrice)) {
            params.put("lowest_rent_fee & <=", endPrice);
        }
        if (DataUtils.isNotNullOrEmpty((Object)shelfStatus)) {
            params.put("shelf_status", shelfStatus);
        }
        if (DataUtils.isNotNullOrEmpty((Object)shortPeriodStatus)) {
            params.put("short_period_status", shortPeriodStatus);
        }
        if (DataUtils.isNotNullOrEmpty((Object)sortMode)) {
            params.put("@order", DynamicUtil.goodsSortMode2String(sortMode));
        }
        if (count) {
            params.put("@query", "count(id) ");
        } else {
            params.put("@query", "id");
        }
        params.put("@table", "goods");
        return params;
    }

    private static String goodsSortMode2String(Integer sortMode) {
        String sortString = null;
        switch (sortMode) {
            case 10: {
                sortString = "stock desc";
                break;
            }
            case 20: {
                sortString = "update_at desc";
                break;
            }
            case 30: {
                sortString = "total_sales desc";
                break;
            }
            case 40: {
                sortString = "lowest_rent_fee asc";
                break;
            }
            case 45: {
                sortString = "lowest_rent_fee desc";
            }
        }
        return sortString;
    }

    public static Map<String, Object> getAddressList(Long uid) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("@table", "address");
        if (DataUtils.isNotNullOrEmpty((Object)uid)) {
            params.put("address.uid", uid);
        }
        params.put("@order", "  address.is_default_address desc, address.update_at desc  ");
        params.put("@query", "address.id");
        return params;
    }

    public static Map<String, Object> getBillsByDeviceInfo(List<SaledOrders> saledOrdersList) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        Long time = System.currentTimeMillis();
        params.put("@table", "bill");
        if (CollectionUtils.isNotEmpty(saledOrdersList)) {
            StringBuilder deviceNumStr = new StringBuilder();
            StringBuilder deviceSerialNumStr = new StringBuilder();
            StringBuilder rentOidStr = new StringBuilder();
            if (saledOrdersList.size() > 1) {
                for (SaledOrders saledOrders : saledOrdersList) {
                    if (saledOrders == null) continue;
                    deviceNumStr.append(saledOrders.getReturnDeviceNum());
                    deviceNumStr.append(",");
                    deviceSerialNumStr.append(saledOrders.getReturnDeviceSerialNum());
                    deviceSerialNumStr.append(",");
                    rentOidStr.append(saledOrders.getRentOid());
                    rentOidStr.append(",");
                }
                deviceNumStr.deleteCharAt(deviceNumStr.length() - 1);
                deviceSerialNumStr.deleteCharAt(deviceSerialNumStr.length() - 1);
                params.put("bill.device_num & in ", "(" + deviceNumStr.toString() + ")");
                params.put("bill.device_serial_num & in ", "(" + deviceSerialNumStr.toString() + ")");
                params.put("bill.rent_oid & in ", "(" + rentOidStr.toString() + ")");
            } else {
                params.put("bill.device_num  ", saledOrdersList.get(0).getReturnDeviceNum());
                params.put("bill.device_serial_num  ", saledOrdersList.get(0).getReturnDeviceSerialNum());
                params.put("bill.rent_oid  ", saledOrdersList.get(0).getRentOid());
            }
            params.put("bill.period_start  & <= ", time);
            params.put("bill.period_end  & <= ", time);
        }
        params.put("@query", "bill.id");
        return params;
    }

    public static Map<String, Object> getRentOrdersListByUidAndStatusAndCreateAt(Long uid, Integer orderStatus, Long startAt, Long endAt, boolean count) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (DataUtils.isNotNullOrEmpty((Object)uid)) {
            params.put("uid", uid);
        }
        if (DataUtils.isNotNullOrEmpty((Object)orderStatus)) {
            params.put("order_status", orderStatus);
        }
        if (DataUtils.isNotNullOrEmpty((Object)startAt)) {
            params.put("create_at & >=", startAt);
        }
        if (DataUtils.isNotNullOrEmpty((Object)endAt)) {
            params.put("create_at & <=", endAt);
        }
        if (count) {
            params.put("@query", "count(id)");
        } else {
            params.put("@query", "id");
        }
        params.put("@table", "rent_orders");
        params.put("@order", "create_at desc");
        return params;
    }

    public static Map<String, Object> getRentOrdersByParentIdAndOrderStatus(Long parentOid, Integer ordersStatus) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (DataUtils.isNotNullOrEmpty((Object)parentOid)) {
            params.put("parent_oid", parentOid);
        }
        if (DataUtils.isNotNullOrEmpty((Object)ordersStatus)) {
            params.put("orders_status", ordersStatus);
        }
        params.put("@query", "id");
        params.put("@table", "rent_orders");
        return params;
    }

    public static Map<String, Object> getSaledOrdersByTypeAndPayStatus(Integer saledOrdersType, Integer payStatus, boolean count) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("@table", "saled_orders");
        if (DataUtils.isNotNullOrEmpty((Object)saledOrdersType)) {
            params.put("saled_orders.saled_orders_type", saledOrdersType);
        }
        if (DataUtils.isNotNullOrEmpty((Object)payStatus)) {
            params.put("saled_orders.pay_status", payStatus);
        }
        if (count) {
            params.put("@query", " count(saled_orders.id) ");
        } else {
            params.put("@order", " saled_orders.create_at desc ");
            params.put("@query", " saled_orders.id ");
        }
        return params;
    }

    public static Map<String, Object> getSaledOrdersRemark(Long saledOrdersId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("@table", "saled_orders_remark");
        if (DataUtils.isNotNullOrEmpty((Object)saledOrdersId)) {
            params.put("saled_orders_remark.saled_orders_id", saledOrdersId);
        }
        return params;
    }

    public static Map<String, Object> getRentOrdersIdsParams(Long uid, Integer rentOrdersStatus, boolean count) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("@table", "rent_orders");
        if (DataUtils.isNotNullOrEmpty((Object)uid)) {
            params.put("rent_orders.uid", uid);
        }
        if (DataUtils.isNotNullOrEmpty((Object)rentOrdersStatus)) {
            params.put("rent_orders.orders_status", rentOrdersStatus);
        }
        if (count) {
            params.put("@query", " count(rent_orders.id) ");
        } else {
            params.put("@order", " rent_orders.create_at desc ");
            params.put("@query", " rent_orders.id ");
        }
        return params;
    }

    public static Map<String, Object> getRentOrdersDeviceListParam(List<Long> rentOrdersIdList, Integer deviceStatus, boolean isCount) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("@table", "rent_orders_device_relation ");
        if (CollectionUtils.isNotEmpty(rentOrdersIdList)) {
            StringBuffer sb = new StringBuffer();
            if (rentOrdersIdList.size() > 1) {
                for (Long rentOrdersId : rentOrdersIdList) {
                    if (rentOrdersId == null) continue;
                    sb.append(rentOrdersId.toString());
                    sb.append(",");
                }
                sb.deleteCharAt(sb.length() - 1);
                params.put("rent_orders_device_relation.oid & in ", "(" + sb.toString() + ")");
            } else {
                params.put("rent_orders_device_relation.oid ", rentOrdersIdList.get(0));
            }
        }
        if (DataUtils.isNotNullOrEmpty((Object)deviceStatus)) {
            params.put("rent_orders_device_relation.device_status", deviceStatus);
        }
        if (isCount) {
            params.put("@query", "count(id) ");
        } else {
            params.put("@order", "update_at desc ");
            params.put("@query", "id ");
        }
        return params;
    }

    public static Map<String, Object> getDeviceStatus(List<SaledOrders> saledOrdersList) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("@table", "rent_orders_device_relation ");
        if (CollectionUtils.isNotEmpty(saledOrdersList)) {
            StringBuffer sbDeviceNum = new StringBuffer();
            StringBuffer sbSaledOrdersId = new StringBuffer();
            if (saledOrdersList.size() > 1) {
                for (SaledOrders saledOrders : saledOrdersList) {
                    if (saledOrders == null) continue;
                    sbDeviceNum.append(saledOrders.getReturnDeviceNum());
                    sbDeviceNum.append(",");
                    sbSaledOrdersId.append(saledOrders.getId());
                    sbSaledOrdersId.append(",");
                }
                sbDeviceNum.deleteCharAt(sbDeviceNum.length() - 1);
                sbDeviceNum.deleteCharAt(sbDeviceNum.length() - 1);
                sbSaledOrdersId.deleteCharAt(sbSaledOrdersId.length() - 1);
                sbSaledOrdersId.deleteCharAt(sbSaledOrdersId.length() - 1);
                params.put("rent_orders_device_relation.device_num & in ", "(" + sbDeviceNum.toString() + ")");
                params.put("rent_orders_device_relation.oid & in ", "(" + sbSaledOrdersId.toString() + ")");
            } else {
                params.put("rent_orders_device_relation.device_num ", saledOrdersList.get(0).getReturnDeviceNum());
                params.put("rent_orders_device_relation.oid ", saledOrdersList.get(0).getId());
            }
        }
        params.put("@query", "distinct rent_orders_device_relationid ");
        return params;
    }

    public static Map<String, Object> getRefundOidBySaledOrdersNum(String saledOrdersNum) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("@table", "refund_orders ");
        if (DataUtils.isNotNullOrEmpty((Object)saledOrdersNum)) {
            params.put("refund_orders.associated_order_number", "'" + saledOrdersNum + "'");
        }
        params.put("@query", "refund_orders.id ");
        return params;
    }

    public static Map<String, Object> getBillIdsByRentDeviceRelationIdList(List<Long> rentOrdersDeviceRelationIdList) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("@table", "bill ");
        if (CollectionUtils.isNotEmpty(rentOrdersDeviceRelationIdList)) {
            if (rentOrdersDeviceRelationIdList.size() > 1) {
                Long[] array = new Long[rentOrdersDeviceRelationIdList.size()];
                Long[] rentOrdersDeviceRelationIdArr = rentOrdersDeviceRelationIdList.toArray(array);
                params.put("rent_device_relation_id & in ", "(" + rentOrdersDeviceRelationIdArr + ")");
            } else {
                params.put("rent_device_relation_id ", rentOrdersDeviceRelationIdList.get(0));
            }
        }
        params.put("@query", "id ");
        return params;
    }

    public static Map<String, Object> getSaledOrdersBillBySaledOid(Long saledOid) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("@table", "bill ");
        params.put("bill_type ", 20);
        if (DataUtils.isNotNullOrEmpty((Object)saledOid)) {
            params.put("saled_oid ", saledOid);
        }
        params.put("@query", "id ");
        return params;
    }

    public static Map<String, Object> getRentOrdersByStatus(Long expectedTime, Integer ordersStatus, boolean count) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (DataUtils.isNotNullOrEmpty((Object)expectedTime)) {
            params.put("create_at & <=", expectedTime);
        }
        if (DataUtils.isNotNullOrEmpty((Object)ordersStatus)) {
            params.put("orders_status", ordersStatus);
        }
        if (count) {
            params.put("@query", " count(id) ");
        } else {
            params.put("@order", "create_at desc ");
            params.put("@query", "id");
        }
        params.put("@table", "rent_orders");
        return params;
    }
}

