-- ----------------------------
-- Table structure for `ticket`
-- ----------------------------
-- DROP TABLE IF EXISTS `ticket`;
CREATE TABLE `ticket` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `oid` bigint NOT NULL   COMMENT '订单id',  
    `bid` bigint NOT NULL   COMMENT '账单id',  
    `uid` bigint NOT NULL   COMMENT '用户id',  
    `ticket_status` tinyint(4) NOT NULL   COMMENT '开票状态 1-待审核  2-已完成  3-已拒绝',  
    `saled_service_num` varchar(20) NOT NULL   COMMENT '发票售后编号（申请开票时，生成的编号）',  
    `ticket_num` varchar(20) NOT NULL   COMMENT '票据编号（纸质发票的编号）',  
    `ticket_fee` decimal NOT NULL   COMMENT '开票金额',  
    `ticket_type` tinyint(4) NOT NULL   COMMENT '发票类型，参见约定  1-增值税普通发票  2-增值税专用发票  3-电子发票',  
    `title_type` tinyint(4) NOT NULL   COMMENT '发票抬头类型，参见约定  1-企业  2-个人',  
    `print_status` tinyint(4) NOT NULL   COMMENT '发票打印状态，参见约定  1-未打印  2-已打印',  
    `title` varchar(30) NOT NULL   COMMENT '发票抬头',  
    `recognise_num` varchar(25) NOT NULL   COMMENT '纳税人识别号',  
    `registry_place` varchar(40) NOT NULL   COMMENT '工商注册地',  
    `registry_phone` varchar(15) NOT NULL   COMMENT '工商注册电话',  
    `open_bank` varchar(30) NOT NULL   COMMENT '开户行',  
    `bank_account` varchar(20) NOT NULL   COMMENT '银行账户',  
    `ticket_content_type` tinyint(4) NOT NULL   COMMENT '发票内容类型，参见约定 1-设备租赁  2-技术服务  3-设备租赁+技术服务',  
    `receiver` varchar(10) NOT NULL   COMMENT '收件人',  
    `receive_phone` varchar(20) NOT NULL   COMMENT '收件人电话',  
    `receive_province` varchar(10) NOT NULL   COMMENT '收件地址-省',  
    `receive_city` varchar(10) NOT NULL   COMMENT '收件地址-市',  
    `receive_district` varchar(10) NOT NULL   COMMENT '收件地址-县',
    `receive_detail` varchar(30) NOT NULL   COMMENT '收件地址-详细',  
    `receive_mail` varchar(20) NOT NULL   COMMENT '收件邮箱',  
    `remark` varchar(100) NOT NULL   COMMENT '备注',  
    `create_at` bigint NOT NULL   COMMENT '创建时间',  
    `update_at` bigint NOT NULL   COMMENT '更新时间',  
    `create_by` bigint NOT NULL   COMMENT '创建人',  
    `update_by` bigint NOT NULL   COMMENT '更新人',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;





