-- ----------------------------
-- Table structure for `saled_orders`
-- ----------------------------
-- DROP TABLE IF EXISTS `saled_orders`;
CREATE TABLE `saled_orders` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `saled_orders_num` varchar(20) NOT NULL   COMMENT '售后单号',  
    `saled_orders_type` tinyint(4) NOT NULL   COMMENT '售后订单类型  1-退货  2-换货  3-返修  4-违约',  
    `oid` bigint NOT NULL   COMMENT '订单id',  
    `device_num` varchar(50) NOT NULL   COMMENT '设备编号',  
    `device_serial_num` varchar(50) NOT NULL   COMMENT '设备序列号',
    `device_info` varchar(255) NOT NULL   COMMENT '设备展示信息',
    `saled_orders_fee` decimal NOT NULL   COMMENT '售后服务费用',
    `return_rent_fee` decimal NOT NULL   COMMENT '返还的租赁费用',
    `keep_fee` decimal NOT NULL   COMMENT '押金',
    `pay_status` tinyint(4) NOT NULL   COMMENT '支付状态，参见约定  1-未支付  2-已支付',  
    `problem` varchar(100) NOT NULL   COMMENT '问题描述',  
    `imgs` text NOT NULL   COMMENT '附件截图，json格式的字符串',  
    `saled_orders_status` tinyint(4) NOT NULL   COMMENT '售后订单状态 1-待审核  2-已拒绝  3-待发货  4-已发货  5-已完成',  
    `delivery_num` varchar(30) NOT NULL   COMMENT '物流运单号',  
    `create_at` bigint NOT NULL   COMMENT '创建时间',  
    `update_at` bigint NOT NULL   COMMENT '更新时间',  
    `create_by` bigint NOT NULL   COMMENT '创建人',  
    `update_by` bigint NOT NULL   COMMENT '更新人',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;





