-- ----------------------------
-- Table structure for `rent_orders`
-- ----------------------------
-- DROP TABLE IF EXISTS `rent_orders`;
CREATE TABLE `rent_orders` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `uid` bigint(20) NOT NULL   COMMENT '用户id',  
    `user_name` varchar(15) NOT NULL   COMMENT '用户账户（用户名）',  
    `orders_number` bigint(20) NOT NULL   COMMENT '订单编号（订单编号规则待定）',  
    `parent_oid` bigint(20) NOT NULL   COMMENT '父订单id',  
    `parent_orders_number` bigint(20) NOT NULL   COMMENT '父订单编号（订单编号规则待定）',  
    `orders_status` tinyint(4) NOT NULL   COMMENT '订单状态',  
    `receiver` varchar(20) NOT NULL   COMMENT '收货人姓名',  
    `receive_province` varchar(15) NOT NULL   COMMENT '省',  
    `receive_city` varchar(15) NOT NULL   COMMENT '市',  
    `receive_district` varchar(15) NOT NULL   COMMENT '区',  
    `receive_detail` varchar(100) NOT NULL   COMMENT '收货地址',  
    `receive_phone` varchar(15) NOT NULL   COMMENT '联系方式',  
    `pickup_method` tinyint(4) NOT NULL   COMMENT '收货方式(快递，自提)',  
    `user_remarks` varchar(101) NOT NULL   COMMENT '用户订单备注',  
    `pay_method` tinyint(4) NOT NULL   COMMENT '支付方式(线下，微信)',  
    `pay_account` varchar(100) NOT NULL   COMMENT '支付账号',  
    `sku_id` bigint(20) NOT NULL   COMMENT '商品sku_id',  
    `sku_attributes` varchar(255) NOT NULL   COMMENT '商品属性',  
    `goods_name` varchar(100) NOT NULL   COMMENT '商品名称',  
    `sku_amount` int(10) NOT NULL   COMMENT '商品数量',  
    `goods_img` varchar(255) NOT NULL   COMMENT '商品图片',  
    `pay_mode` tinyint(4) NOT NULL   COMMENT '支付模式（月付、季付、年付）',  
    `totle_fee` decimal(20) NOT NULL   COMMENT '总金额',  
    `transportation_fee` decimal(20) NOT NULL   COMMENT '运费',  
    `keep_fee` decimal(20) NOT NULL   COMMENT '押金',  
    `security_name` varchar(10) NOT NULL   COMMENT '保修名称',  
    `security_fee` decimal(20) NOT NULL   COMMENT '保修费用/增值保障',  
    `first_rent_fee` decimal(20) NOT NULL   COMMENT '首付租金',  
    `discount_name` varchar(30) NOT NULL   COMMENT '优惠名称',  
    `discount_fee` decimal(20) NOT NULL   COMMENT '优惠金额',  
    `rent_start` bigint(20) NOT NULL   COMMENT '起租日期',  
    `rent_period` int(5) NOT NULL   COMMENT '租期（约定）',  
    `rent_fee` varchar(255) NOT NULL   COMMENT '租金（数组形式的字符串）',  
    `print_status` tinyint(4) NOT NULL   COMMENT '打印状态',  
    `send_at` bigint(20) NOT NULL   COMMENT '发货时间',  
    `finish_at` bigint(20) NOT NULL   COMMENT '成交时间',  
    `back_remarks_id` bigint(20) NOT NULL   COMMENT '后台订单备注id（涉及日志记录）',  
    `payment_number` varchar(40) NOT NULL   COMMENT '支付交易号',  
    `delivery_num` varchar(30) NOT NULL   COMMENT '物流运单号',  
    `create_at` bigint(20) NOT NULL   COMMENT '创建时间',  
    `update_at` bigint(20) NOT NULL   COMMENT '更新时间',  
    `create_by` bigint(20) NOT NULL   COMMENT '创建人',  
    `update_by` bigint(20) NOT NULL   COMMENT '更新人',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;





