-- ----------------------------
-- Table structure for `goods`
-- ----------------------------
-- DROP TABLE IF EXISTS `goods`;
CREATE TABLE `goods` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `goods_sort_id` bigint(20) NOT NULL   COMMENT '商品分类id',  
    `goods_number` varchar(60) NOT NULL   COMMENT '商品编号',  
    `goods_name` varchar(150) NOT NULL   COMMENT '商品名称',  
    `search_key_words` varchar(255) NOT NULL   COMMENT '搜索关键字(保留)',  
    `brand_id` bigint(20) NOT NULL   COMMENT '品牌id',  
    `pc_img` text NOT NULL   COMMENT 'pc图片',  
    `wx_img` text NOT NULL   COMMENT 'wx图片',  
    `lowest_rent_fee` decimal(20) NOT NULL   COMMENT '最低租金（搜索）',  
    `highest_rent_fee` decimal(20) NOT NULL   COMMENT '最高租金（保留）',  
    `total_sales` int(10) NOT NULL   COMMENT '销量（搜索）',  
    `stock` int(10) NOT NULL   COMMENT '库存（搜索）',  
    `shelf_status` tinyint(4) NOT NULL   COMMENT '上下架状态',  
    `create_at` bigint(20) NOT NULL   COMMENT '创建时间',  
    `update_at` bigint(20) NOT NULL   COMMENT '更新时间',  
    `create_by` bigint(20) NOT NULL   COMMENT '创建人',  
    `update_by` bigint(20) NOT NULL   COMMENT '更新人',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;





