-- ----------------------------
-- Table structure for `bill`
-- ----------------------------
-- DROP TABLE IF EXISTS `bill`;
CREATE TABLE `bill` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `bill_type` tinyint(4) NOT NULL   COMMENT '账单类型，参见约定',  
    `rent_oid` bigint NOT NULL   COMMENT '租赁订单id',  
    `saled_oid` bigint NOT NULL   COMMENT '售后订单id',  
    `device_num` varchar(50) NOT NULL   COMMENT '设备编号',  
    `device_serial_num` varchar(50) NOT NULL   COMMENT '设备序列号',  
    `rent_fee` decimal NOT NULL   COMMENT '租金',
    `security_fee` decimal NOT NULL   COMMENT '保险费',
    `saled_order_fee` decimal NOT NULL   COMMENT '售后费',
    `period_start` bigint NOT NULL   COMMENT '账单发生日期',  
    `period_end` bigint NOT NULL   COMMENT '账单截至日期',  
    `period_num` int NOT NULL   COMMENT '账单期数',  
    `bill_create_status` tinyint(4) NOT NULL   COMMENT '账单生成状态，参见约定  1-未生成  2-已生成',  
    `pay_status` tinyint(4) NOT NULL   COMMENT '支付状态，参见约定  1-未支付  2-已支付',  
    `pay_method` tinyint(4) NOT NULL   COMMENT '支付方式，参见约定   1-微信支付  2-线下支付',  
    `create_at` bigint NOT NULL   COMMENT '创建时间',  
    `update_at` bigint NOT NULL   COMMENT '更新时间',  
    `create_by` bigint NOT NULL   COMMENT '创建人',  
    `update_by` bigint NOT NULL   COMMENT '更新人',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;





