- ----------------------------
-- Table structure for `bill`
-- ----------------------------
-- DROP TABLE IF EXISTS `bill`;
CREATE TABLE `bill` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `bill_type` tinyint(4) NOT NULL   COMMENT '账单类型，参见约定',  
    `rent_oid` bigint NOT NULL   COMMENT '租赁订单id',  
    `saled_oid` bigint NOT NULL   COMMENT '售后订单id',  
    `device_num` varchar(50) NOT NULL   COMMENT '设备编号',  
    `device_serial_num` varchar(50) NOT NULL   COMMENT '设备序列号',  
    `rent_fee` decimal NOT NULL   COMMENT '租金',
    `security_fee` decimal NOT NULL   COMMENT '保险费',
    `saled_order_fee` decimal NOT NULL   COMMENT '售后费',
    `period_start` bigint NOT NULL   COMMENT '账单发生日期',  
    `period_end` bigint NOT NULL   COMMENT '账单截至日期',  
    `period_num` int NOT NULL   COMMENT '账单期数',  
    `bill_create_status` tinyint(4) NOT NULL   COMMENT '账单生成状态，参见约定  1-未生成  2-已生成',  
    `pay_status` tinyint(4) NOT NULL   COMMENT '支付状态，参见约定  1-未支付  2-已支付',  
    `pay_method` tinyint(4) NOT NULL   COMMENT '支付方式，参见约定   1-微信支付  2-线下支付',  
    `create_at` bigint NOT NULL   COMMENT '创建时间',  
    `update_at` bigint NOT NULL   COMMENT '更新时间',  
    `create_by` bigint NOT NULL   COMMENT '创建人',  
    `update_by` bigint NOT NULL   COMMENT '更新人',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `bill_log`
-- ----------------------------
-- DROP TABLE IF EXISTS `bill_log`;
CREATE TABLE `bill_log` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `bid` bigint NOT NULL   COMMENT '账单id',  
    `bill_log_type` tinyint(4) NOT NULL   COMMENT '账单操作记录类型，参见约定  1-创建账单  2-支付账单',  
    `remark` varchar(100) NOT NULL   COMMENT '账单备注',  
    `create_at` bigint NOT NULL   COMMENT '创建时间',  
    `update_at` bigint NOT NULL   COMMENT '更新时间',  
    `create_by` bigint NOT NULL   COMMENT '创建人',  
    `update_by` bigint NOT NULL   COMMENT '更新人',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `ticket`
-- ----------------------------
-- DROP TABLE IF EXISTS `ticket`;
CREATE TABLE `ticket` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `oid` bigint NOT NULL   COMMENT '订单id',  
    `bid` bigint NOT NULL   COMMENT '账单id',  
    `uid` bigint NOT NULL   COMMENT '用户id',  
    `ticket_status` tinyint(4) NOT NULL   COMMENT '开票状态 1-待审核  2-已完成  3-已拒绝',  
    `saled_service_num` varchar(20) NOT NULL   COMMENT '发票售后编号（申请开票时，生成的编号）',  
    `ticket_num` varchar(20) NOT NULL   COMMENT '票据编号（纸质发票的编号）',  
    `ticket_fee` decimal NOT NULL   COMMENT '开票金额',  
    `ticket_type` tinyint(4) NOT NULL   COMMENT '发票类型，参见约定  1-增值税普通发票  2-增值税专用发票  3-电子发票',  
    `title_type` tinyint(4) NOT NULL   COMMENT '发票抬头类型，参见约定  1-企业  2-个人',  
    `print_status` tinyint(4) NOT NULL   COMMENT '发票打印状态，参见约定  1-未打印  2-已打印',  
    `title` varchar(30) NOT NULL   COMMENT '发票抬头',  
    `recognise_num` varchar(25) NOT NULL   COMMENT '纳税人识别号',  
    `registry_place` varchar(40) NOT NULL   COMMENT '工商注册地',  
    `registry_phone` varchar(15) NOT NULL   COMMENT '工商注册电话',  
    `open_bank` varchar(30) NOT NULL   COMMENT '开户行',  
    `bank_account` varchar(20) NOT NULL   COMMENT '银行账户',  
    `ticket_content_type` tinyint(4) NOT NULL   COMMENT '发票内容类型，参见约定 1-设备租赁  2-技术服务  3-设备租赁+技术服务',  
    `receiver` varchar(10) NOT NULL   COMMENT '收件人',  
    `receive_phone` varchar(20) NOT NULL   COMMENT '收件人电话',  
    `receive_province` varchar(10) NOT NULL   COMMENT '收件地址-省',  
    `receive_city` varchar(10) NOT NULL   COMMENT '收件地址-市',  
    `receive_district` varchar(10) NOT NULL   COMMENT '收件地址-县',
    `receive_detail` varchar(30) NOT NULL   COMMENT '收件地址-详细',  
    `receive_mail` varchar(20) NOT NULL   COMMENT '收件邮箱',  
    `remark` varchar(100) NOT NULL   COMMENT '备注',  
    `create_at` bigint NOT NULL   COMMENT '创建时间',  
    `update_at` bigint NOT NULL   COMMENT '更新时间',  
    `create_by` bigint NOT NULL   COMMENT '创建人',  
    `update_by` bigint NOT NULL   COMMENT '更新人',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `address`
-- ----------------------------
-- DROP TABLE IF EXISTS `address`;
CREATE TABLE `address` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `uid` bigint NOT NULL   COMMENT '用户id',  
    `receiver` varchar(10) NOT NULL   COMMENT '收件人',  
    `receive_phone` varchar(20) NOT NULL   COMMENT '收件人电话',  
    `receive_province` varchar(10) NOT NULL   COMMENT '收件地址-省',  
    `receive_city` varchar(10) NOT NULL   COMMENT '收件地址-市',  
    `receive_district` varchar(10) NOT NULL   COMMENT '收件地址-县',
    `receive_detail` varchar(30) NOT NULL   COMMENT '收件地址-详细',  
    `fix_phone` varchar(20) NOT NULL   COMMENT '固定电话',  
    `mail` varchar(30) NOT NULL   COMMENT '邮箱',  
    `is_default_address` tinyint(4) NOT NULL   COMMENT '是否默认收件地址  1-否  2-是',  
    `create_at` bigint NOT NULL   COMMENT '创建时间',  
    `update_at` bigint NOT NULL   COMMENT '更新时间',  
    `create_by` bigint NOT NULL   COMMENT '创建人',  
    `update_by` bigint NOT NULL   COMMENT '更新人',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `saled_orders`
-- ----------------------------
-- DROP TABLE IF EXISTS `saled_orders`;
CREATE TABLE `saled_orders` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `saled_orders_num` varchar(20) NOT NULL   COMMENT '售后单号',  
    `saled_orders_type` tinyint(4) NOT NULL   COMMENT '售后订单类型  1-退货  2-换货  3-返修  4-违约',  
    `oid` bigint NOT NULL   COMMENT '订单id',  
    `device_num` varchar(50) NOT NULL   COMMENT '设备编号',  
    `device_serial_num` varchar(50) NOT NULL   COMMENT '设备序列号',
    `device_info` varchar(255) NOT NULL   COMMENT '设备展示信息',
    `saled_orders_fee` decimal NOT NULL   COMMENT '售后服务费用',
    `return_rent_fee` decimal NOT NULL   COMMENT '返还的租赁费用',
    `keep_fee` decimal NOT NULL   COMMENT '押金',
    `pay_status` tinyint(4) NOT NULL   COMMENT '支付状态，参见约定  1-未支付  2-已支付',  
    `problem` varchar(100) NOT NULL   COMMENT '问题描述',  
    `imgs` text NOT NULL   COMMENT '附件截图，json格式的字符串',  
    `saled_orders_status` tinyint(4) NOT NULL   COMMENT '售后订单状态 1-待审核  2-已拒绝  3-待发货  4-已发货  5-已完成',  
    `delivery_num` varchar(30) NOT NULL   COMMENT '物流运单号',  
    `create_at` bigint NOT NULL   COMMENT '创建时间',  
    `update_at` bigint NOT NULL   COMMENT '更新时间',  
    `create_by` bigint NOT NULL   COMMENT '创建人',  
    `update_by` bigint NOT NULL   COMMENT '更新人',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `saled_orders_remark`
-- ----------------------------
-- DROP TABLE IF EXISTS `saled_orders_remark`;
CREATE TABLE `saled_orders_remark` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `saled_orders_id` bigint NOT NULL   COMMENT '售后订单id',  
    `remark` varchar(100) NOT NULL   COMMENT '备注',  
    `saled_orders_status` tinyint(4) NOT NULL   COMMENT '售后订单状态 1-待审核  2-已拒绝  3-代发货  4-已发货  5-已完成',  
    `create_at` bigint NOT NULL   COMMENT '创建时间',  
    `update_at` bigint NOT NULL   COMMENT '更新时间',  
    `create_by` bigint NOT NULL   COMMENT '创建人',  
    `update_by` bigint NOT NULL   COMMENT '更新人',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `goods_sort`
-- ----------------------------
-- DROP TABLE IF EXISTS `goods_sort`;
CREATE TABLE `goods_sort` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `sort_name` varchar(10) NOT NULL   COMMENT '类别名称',  
    `sort_level` tinyint(4) NOT NULL   COMMENT '类别等级',  
    `father_id` bigint(20) NOT NULL   COMMENT '父类id',  
    `shelf_status` tinyint(4) NOT NULL   COMMENT '上下架状态',  
    `pc_img` varchar(255) NOT NULL   COMMENT 'pc端图片',  
    `wx_img` varchar(255) NOT NULL   COMMENT '小程序图片',  
    `sort` tinyint(4) NOT NULL   COMMENT '商品类别排序',  
    `create_at` bigint(20) NOT NULL   COMMENT '创建时间',  
    `update_at` bigint(20) NOT NULL   COMMENT '修改时间',  
    `create_by` bigint(20) NOT NULL   COMMENT '创建人',  
    `update_by` bigint(20) NOT NULL   COMMENT '修改人',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `withdraw`
-- ----------------------------
-- DROP TABLE IF EXISTS `withdraw`;
CREATE TABLE `withdraw` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `withdraw_num` varchar(50) NOT NULL   COMMENT '提现编号',  
    `uid` bigint(20) NOT NULL   COMMENT '用户id',  
    `mobile` varchar(11) NOT NULL   COMMENT '用户名',  
    `balance` decimal(20) NOT NULL   COMMENT '用户余额',  
    `withdraw_fee` decimal(20) NOT NULL   COMMENT '提现金额',  
    `cashout_account` varchar(100) NOT NULL   COMMENT '提现账号',  
    `actual_name` varchar(10) NOT NULL   COMMENT '真实姓名',  
    `way` varchar(20) NOT NULL   COMMENT '提现方式',  
    `withdraw_status` tinyint(4) NOT NULL   COMMENT '提现状态',  
    `remark` varchar(100) NOT NULL   COMMENT '审核备注',  
    `create_at` bigint(20) NOT NULL   COMMENT '创建时间',  
    `update_at` bigint(20) NOT NULL   COMMENT '修改时间',  
    `create_by` bigint(20) NOT NULL   COMMENT '创建人',  
    `update_by` bigint(20) NOT NULL   COMMENT '修改人',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `trading_flow`
-- ----------------------------
-- DROP TABLE IF EXISTS `trading_flow`;
CREATE TABLE `trading_flow` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '',  
    `serial_num` varchar(50) NOT NULL   COMMENT '',  
    `uid` bigint(20) NOT NULL   COMMENT '',  
    `trading_sort` tinyint(4) NOT NULL   COMMENT '',  
    `record_type` tinyint(4) NOT NULL   COMMENT '',  
    `transaction_type` tinyint(4) NOT NULL   COMMENT '',  
    `transaction_amount` decimal(20) NOT NULL   COMMENT '',  
    `transaction_time` bigint(20) NOT NULL   COMMENT '',  
    `balance` decimal(20) NOT NULL   COMMENT '',  
    `orders_num` varchar(50) NOT NULL   COMMENT '',  
    `device_serial_num` varchar(50) NOT NULL   COMMENT '',  
    `goods_name` varchar(100) NOT NULL   COMMENT '',  
    `create_at` bigint(20) NOT NULL   COMMENT '',  
    `update_at` bigint(20) NOT NULL   COMMENT '',  
    `create_by` bigint(20) NOT NULL   COMMENT '',  
    `update_by` bigint(20) NOT NULL   COMMENT '',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `stock`
-- ----------------------------
-- DROP TABLE IF EXISTS `stock`;
CREATE TABLE `stock` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '',  
    `stock_num` varchar(50) NOT NULL   COMMENT '',  
    `goods_name` varchar(100) NOT NULL   COMMENT '',  
    `goods_num` varchar(50) NOT NULL   COMMENT '',  
    `orders_num` varchar(50) NOT NULL   COMMENT '',  
    `brand_name` varchar(10) NOT NULL   COMMENT '',  
    `sku` varchar(50) NOT NULL   COMMENT '',  
    `operate_account` varchar(20) NOT NULL   COMMENT '',  
    `operate_type` tinyint(4) NOT NULL   COMMENT '',  
    `operate_amount` int(11) NOT NULL   COMMENT '',  
    `operate_time` bigint(20) NOT NULL   COMMENT '',  
    `stock_amount` int(11) NOT NULL   COMMENT '',  
    `stock_type` tinyint(4) NOT NULL   COMMENT '',  
    `create_at` bigint(20) NOT NULL   COMMENT '',  
    `update_at` bigint(20) NOT NULL   COMMENT '',  
    `create_by` bigint(20) NOT NULL   COMMENT '',  
    `update_by` bigint(20) NOT NULL   COMMENT '',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `login_log`
-- ----------------------------
-- DROP TABLE IF EXISTS `login_log`;
CREATE TABLE `login_log` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '',  
    `uid` bigint(20) NOT NULL   COMMENT '',  
    `login_time` bigint(20) NOT NULL   COMMENT '',  
    `login_ip` varchar(20) NOT NULL   COMMENT '',  
    `login_address` varchar(20) NOT NULL   COMMENT '',  
    `login_type` tinyint(4) NOT NULL   COMMENT '',  
    `create_at` bigint(20) NOT NULL   COMMENT '',  
    `update_at` bigint(20) NOT NULL   COMMENT '',  
    `create_by` bigint(20) NOT NULL   COMMENT '',  
    `update_by` bigint(20) NOT NULL   COMMENT '',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `account`
-- ----------------------------
-- DROP TABLE IF EXISTS `account`;
CREATE TABLE `account` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '',  
    `keep_fee` decimal(20) NOT NULL   COMMENT '',  
    `spend` decimal(20) NOT NULL   COMMENT '',  
    `balance` decimal(20) NOT NULL   COMMENT '',  
    `refund_amount` decimal(20) NOT NULL   COMMENT '',  
    `rework_amount` decimal(20) NOT NULL   COMMENT '',  
    `default_amount` decimal(20) NOT NULL   COMMENT '',  
    `create_at` bigint(20) NOT NULL   COMMENT '',  
    `update_at` bigint(20) NOT NULL   COMMENT '',  
    `create_by` bigint(20) NOT NULL   COMMENT '',  
    `update_by` bigint(20) NOT NULL   COMMENT '',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `user`
-- ----------------------------
-- DROP TABLE IF EXISTS `user`;
CREATE TABLE `user` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '',  
    `user_img` varchar(255) NOT NULL   COMMENT '',  
    `mobile` varchar(11) NOT NULL   COMMENT '',  
    `nick` varchar(20) NOT NULL   COMMENT '',  
    `pwd` varchar(50) NOT NULL   COMMENT '',  
    `orders_amount` int(11) NOT NULL   COMMENT '',  
    `lease_device` int(11) NOT NULL   COMMENT '',  
    `return_frequency` int(11) NOT NULL   COMMENT '',  
    `exchange_frequency` int(11) NOT NULL   COMMENT '',  
    `rework_frequency` int(11) NOT NULL   COMMENT '',  
    `login_frequency` int(11) NOT NULL   COMMENT '',  
    `status` tinyint(4) NOT NULL   COMMENT '',  
    `os` varchar(20) NOT NULL   COMMENT '',  
    `token` varchar(255) NOT NULL   COMMENT '',  
    `login_time` bigint(20) NOT NULL   COMMENT '',  
    `device_token` varchar(255) NOT NULL   COMMENT '',  
    `open_id_wx` varchar(50) NOT NULL   COMMENT '',  
    `open_id_pc` varchar(50) NOT NULL   COMMENT '',  
    `integral` int(11) NOT NULL   COMMENT '',  
    `union_id` varchar(50) NOT NULL   COMMENT '',  
    `create_at` bigint(20) NOT NULL   COMMENT '',  
    `update_at` bigint(20) NOT NULL   COMMENT '',  
    `create_by` bigint(20) NOT NULL   COMMENT '',  
    `update_by` bigint(20) NOT NULL   COMMENT '',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `topic`
-- ----------------------------
-- DROP TABLE IF EXISTS `topic`;
CREATE TABLE `topic` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '',  
    `topic_name` varchar(10) NOT NULL   COMMENT '',  
    `shelf_status` tinyint(4) NOT NULL   COMMENT '',  
    `goods_amount` tinyint(4) NOT NULL   COMMENT '',  
    `sort` int(11) NOT NULL   COMMENT '',  
    `create_at` bigint(20) NOT NULL   COMMENT '',  
    `update_at` bigint(20) NOT NULL   COMMENT '',  
    `create_by` bigint(20) NOT NULL   COMMENT '',  
    `update_by` bigint(20) NOT NULL   COMMENT '',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `topic_goods`
-- ----------------------------
-- DROP TABLE IF EXISTS `topic_goods`;
CREATE TABLE `topic_goods` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '',  
    `goods_num` varchar(50) NOT NULL   COMMENT '',  
    `goods_id` bigint(20) NOT NULL   COMMENT '',  
    `shelf_status` tinyint(4) NOT NULL   COMMENT '',  
    `topic_id` bigint(20) NOT NULL   COMMENT '',  
    `sort` int(11) NOT NULL   COMMENT '',  
    `create_at` bigint(20) NOT NULL   COMMENT '',  
    `update_at` bigint(20) NOT NULL   COMMENT '',  
    `create_by` bigint(20) NOT NULL   COMMENT '',  
    `update_by` bigint(20) NOT NULL   COMMENT '',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `brand`
-- ----------------------------
-- DROP TABLE IF EXISTS `brand`;
CREATE TABLE `brand` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '',  
    `brand_name` varchar(10) NOT NULL   COMMENT '',  
    `logo` varchar(255) NOT NULL   COMMENT '',  
    `shelf_status` tinyint(4) NOT NULL   COMMENT '',  
    `sort` int(11) NOT NULL   COMMENT '',  
    `create_at` bigint(20) NOT NULL   COMMENT '',  
    `update_at` bigint(20) NOT NULL   COMMENT '',  
    `create_by` bigint(20) NOT NULL   COMMENT '',  
    `update_by` bigint(20) NOT NULL   COMMENT '',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `shopping_cart`
-- ----------------------------
-- DROP TABLE IF EXISTS `shopping_cart`;
CREATE TABLE `shopping_cart` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '',  
    `uid` bigint(20) NOT NULL   COMMENT '',  
    `sku_id` bigint(20) NOT NULL   COMMENT '',  
    `goods_amount` int(11) NOT NULL   COMMENT '',  
    `start_lease_date` bigint(20) NOT NULL   COMMENT '',  
    `pay_mode` bigint(20) NOT NULL   COMMENT '',  
    `rent_period` tinyint(4) NOT NULL   COMMENT '',  
    `goods_security` bigint(20) NOT NULL   COMMENT '',  
    `create_at` bigint(20) NOT NULL   COMMENT '',  
    `update_at` bigint(20) NOT NULL   COMMENT '',  
    `create_by` bigint(20) NOT NULL   COMMENT '',  
    `update_by` bigint(20) NOT NULL   COMMENT '',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `goods_sort_attributes`
-- ----------------------------
-- DROP TABLE IF EXISTS `goods_sort_attributes`;
CREATE TABLE `goods_sort_attributes` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `attributes_name` varchar(20) NOT NULL   COMMENT '属性名称',  
    `goods_sort_id` bigint(20) NOT NULL   COMMENT '商品类别id',  
    `attributes_list` varchar(500) NOT NULL   COMMENT '属性列表',  
    `create_at` bigint(20) NOT NULL   COMMENT '创建时间',  
    `update_at` bigint(20) NOT NULL   COMMENT '更新时间',  
    `create_by` bigint(20) NOT NULL   COMMENT '创建人',  
    `update_by` bigint(20) NOT NULL   COMMENT '更新人',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `goods`
-- ----------------------------
-- DROP TABLE IF EXISTS `goods`;
CREATE TABLE `goods` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `goods_sort_id` bigint(20) NOT NULL   COMMENT '商品分类id',  
    `goods_number` varchar(60) NOT NULL   COMMENT '商品编号',  
    `goods_name` varchar(150) NOT NULL   COMMENT '商品名称',  
    `search_key_words` varchar(255) NOT NULL   COMMENT '搜索关键字(保留)',  
    `brand_id` bigint(20) NOT NULL   COMMENT '品牌id',  
    `pc_img` text NOT NULL   COMMENT 'pc图片',  
    `wx_img` text NOT NULL   COMMENT 'wx图片',  
    `lowest_rent_fee` decimal(20) NOT NULL   COMMENT '最低租金（搜索）',  
    `highest_rent_fee` decimal(20) NOT NULL   COMMENT '最高租金（保留）',  
    `total_sales` int(10) NOT NULL   COMMENT '销量（搜索）',  
    `stock` int(10) NOT NULL   COMMENT '库存（搜索）',  
    `shelf_status` tinyint(4) NOT NULL   COMMENT '上下架状态',  
    `create_at` bigint(20) NOT NULL   COMMENT '创建时间',  
    `update_at` bigint(20) NOT NULL   COMMENT '更新时间',  
    `create_by` bigint(20) NOT NULL   COMMENT '创建人',  
    `update_by` bigint(20) NOT NULL   COMMENT '更新人',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `goods_log`
-- ----------------------------
-- DROP TABLE IF EXISTS `goods_log`;
CREATE TABLE `goods_log` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `goods_id` bigint(20) NOT NULL   COMMENT '商品id',  
    `goods_number` varchar(50) NOT NULL   COMMENT '商品编号',  
    `goods_name` varchar(150) NOT NULL   COMMENT '商品名称',  
    `goods_img` varchar(255) NOT NULL   COMMENT '商品图片',  
    `brand_id` bigint(20) NOT NULL   COMMENT '品牌id',  
    `brand_name` varchar(50) NOT NULL   COMMENT '品牌名称',  
    `operation_descripe` tinyint(4) NOT NULL   COMMENT '操作描述',  
    `creater_name` varchar(50) NOT NULL   COMMENT '操作人姓名',  
    `create_at` bigint(20) NOT NULL   COMMENT '创建时间',  
    `update_at` bigint(20) NOT NULL   COMMENT '更新时间',  
    `create_by` bigint(20) NOT NULL   COMMENT '创建人',  
    `update_by` bigint(20) NOT NULL   COMMENT '更新人',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `goods_sku`
-- ----------------------------
-- DROP TABLE IF EXISTS `goods_sku`;
CREATE TABLE `goods_sku` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `goods_id` bigint(20) NOT NULL   COMMENT '商品id',  
    `sku_number` varchar(50) NOT NULL   COMMENT 'sku编号',  
    `sku_attributes` varchar(255) NOT NULL   COMMENT 'sku属性值(用于展示的字符串)',  
    `sku_details` text NOT NULL   COMMENT 'sku详细(sku参数)',  
    `sku_hash` int(10) NOT NULL   COMMENT 'sku哈希值',  
    `keep_fee` decimal(20) NOT NULL   COMMENT '押金',  
    `increase_num` bigint(20) NOT NULL   COMMENT '自增数',  
    `stock` int(10) NOT NULL   COMMENT '库存',  
    `total_sales` int(10) NOT NULL   COMMENT '销量',  
    `shelf_status` tinyint(4) NOT NULL   COMMENT '上下架状态',  
    `create_at` bigint(20) NOT NULL   COMMENT '创建时间',  
    `update_at` bigint(20) NOT NULL   COMMENT '更新时间',  
    `create_by` bigint(20) NOT NULL   COMMENT '创建人',  
    `update_by` bigint(20) NOT NULL   COMMENT '更新人',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `goods_sku_pay_mode_relation`
-- ----------------------------
-- DROP TABLE IF EXISTS `goods_sku_pay_mode_relation`;
CREATE TABLE `goods_sku_pay_mode_relation` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `sku_id` bigint(20) NOT NULL   COMMENT 'skuid',  
    `pay_mode` int(4) NOT NULL   COMMENT '支付模式（月付季付）',  
    `discount_fee` decimal(20) NOT NULL   COMMENT '优惠金额',  
    `create_at` bigint(20) NOT NULL   COMMENT '创建时间',  
    `update_at` bigint(20) NOT NULL   COMMENT '更新时间',  
    `create_by` bigint(20) NOT NULL   COMMENT '创建人',  
    `update_by` bigint(20) NOT NULL   COMMENT '更新人',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `goods_sku_rent_fee_period`
-- ----------------------------
-- DROP TABLE IF EXISTS `goods_sku_rent_fee_period`;
CREATE TABLE `goods_sku_rent_fee_period` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `sku_id` bigint(20) NOT NULL   COMMENT 'skuid',  
    `rent_period` bigint(20) NOT NULL   COMMENT '租期（见约定）',  
    `rent_fee` varchar(255) NOT NULL   COMMENT '租期 数组格式的租金',  
    `create_at` bigint(20) NOT NULL   COMMENT '创建时间',  
    `update_at` bigint(20) NOT NULL   COMMENT '更新时间',  
    `create_by` bigint(20) NOT NULL   COMMENT '创建人',  
    `update_by` bigint(20) NOT NULL   COMMENT '更新人',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `goods_security`
-- ----------------------------
-- DROP TABLE IF EXISTS `goods_security`;
CREATE TABLE `goods_security` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `security_name` varchar(10) NOT NULL   COMMENT '保险名称',  
    `security_fee` decimal(20) NOT NULL   COMMENT '保险金额',  
    `create_at` bigint(20) NOT NULL   COMMENT '创建时间',  
    `update_at` bigint(20) NOT NULL   COMMENT '更新时间',  
    `create_by` bigint(20) NOT NULL   COMMENT '创建人',  
    `update_by` bigint(20) NOT NULL   COMMENT '更新人',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `goods_sku_security_relation`
-- ----------------------------
-- DROP TABLE IF EXISTS `goods_sku_security_relation`;
CREATE TABLE `goods_sku_security_relation` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `sku_id` bigint(20) NOT NULL   COMMENT 'skuid',  
    `security_id` bigint(20) NOT NULL   COMMENT '保险id',  
    `create_at` bigint(20) NOT NULL   COMMENT '创建时间',  
    `update_at` bigint(20) NOT NULL   COMMENT '更新时间',  
    `create_by` bigint(20) NOT NULL   COMMENT '创建人',  
    `update_by` bigint(20) NOT NULL   COMMENT '更新人',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `rent_orders`
-- ----------------------------
-- DROP TABLE IF EXISTS `rent_orders`;
CREATE TABLE `rent_orders` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `uid` bigint(20) NOT NULL   COMMENT '用户id',  
    `user_name` varchar(15) NOT NULL   COMMENT '用户账户（用户名）',  
    `orders_number` bigint(20) NOT NULL   COMMENT '订单编号（订单编号规则待定）',  
    `parent_oid` bigint(20) NOT NULL   COMMENT '父订单id',  
    `parent_orders_number` bigint(20) NOT NULL   COMMENT '父订单编号（订单编号规则待定）',  
    `orders_status` tinyint(4) NOT NULL   COMMENT '订单状态',  
    `receiver` varchar(20) NOT NULL   COMMENT '收货人姓名',  
    `receive_province` varchar(15) NOT NULL   COMMENT '省',  
    `receive_city` varchar(15) NOT NULL   COMMENT '市',  
    `receive_district` varchar(15) NOT NULL   COMMENT '区',  
    `receive_detail` varchar(100) NOT NULL   COMMENT '收货地址',  
    `receive_phone` varchar(15) NOT NULL   COMMENT '联系方式',  
    `pickup_method` tinyint(4) NOT NULL   COMMENT '收货方式(快递，自提)',  
    `user_remarks` varchar(101) NOT NULL   COMMENT '用户订单备注',  
    `pay_method` tinyint(4) NOT NULL   COMMENT '支付方式(线下，微信)',  
    `pay_account` varchar(100) NOT NULL   COMMENT '支付账号',  
    `sku_id` bigint(20) NOT NULL   COMMENT '商品sku_id',  
    `sku_attributes` varchar(255) NOT NULL   COMMENT '商品属性',  
    `goods_name` varchar(100) NOT NULL   COMMENT '商品名称',  
    `sku_amount` int(10) NOT NULL   COMMENT '商品数量',  
    `goods_img` varchar(255) NOT NULL   COMMENT '商品图片',  
    `pay_mode` tinyint(4) NOT NULL   COMMENT '支付模式（月付、季付、年付）',  
    `totle_fee` decimal(20) NOT NULL   COMMENT '总金额',  
    `transportation_fee` decimal(20) NOT NULL   COMMENT '运费',  
    `keep_fee` decimal(20) NOT NULL   COMMENT '押金',  
    `security_name` varchar(10) NOT NULL   COMMENT '保修名称',  
    `security_fee` decimal(20) NOT NULL   COMMENT '保修费用/增值保障',  
    `first_rent_fee` decimal(20) NOT NULL   COMMENT '首付租金',  
    `discount_name` varchar(30) NOT NULL   COMMENT '优惠名称',  
    `discount_fee` decimal(20) NOT NULL   COMMENT '优惠金额',  
    `rent_start` bigint(20) NOT NULL   COMMENT '起租日期',  
    `rent_period` int(5) NOT NULL   COMMENT '租期（约定）',  
    `rent_fee` varchar(255) NOT NULL   COMMENT '租金（数组形式的字符串）',  
    `print_status` tinyint(4) NOT NULL   COMMENT '打印状态',  
    `send_at` bigint(20) NOT NULL   COMMENT '发货时间',  
    `finish_at` bigint(20) NOT NULL   COMMENT '成交时间',  
    `back_remarks_id` bigint(20) NOT NULL   COMMENT '后台订单备注id（涉及日志记录）',  
    `payment_number` varchar(40) NOT NULL   COMMENT '支付交易号',  
    `delivery_num` varchar(30) NOT NULL   COMMENT '物流运单号',  
    `create_at` bigint(20) NOT NULL   COMMENT '创建时间',  
    `update_at` bigint(20) NOT NULL   COMMENT '更新时间',  
    `create_by` bigint(20) NOT NULL   COMMENT '创建人',  
    `update_by` bigint(20) NOT NULL   COMMENT '更新人',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `rent_orders_device_relation`
-- ----------------------------
-- DROP TABLE IF EXISTS `rent_orders_device_relation`;
CREATE TABLE `rent_orders_device_relation` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `oid` bigint(20) NOT NULL   COMMENT '租赁订单id',  
    `device_num` varchar(50) NOT NULL   COMMENT '设备编号',  
    `device_serial_num` varchar(50) NOT NULL   COMMENT '设备序列号',  
    `device_status` tinyint(4) NOT NULL   COMMENT '设备状态',  
    `create_at` bigint(20) NOT NULL   COMMENT '创建时间',  
    `update_at` bigint(20) NOT NULL   COMMENT '更新时间',  
    `create_by` bigint(20) NOT NULL   COMMENT '创建人',  
    `update_by` bigint(20) NOT NULL   COMMENT '更新人',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `orders_remarks_log`
-- ----------------------------
-- DROP TABLE IF EXISTS `orders_remarks_log`;
CREATE TABLE `orders_remarks_log` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `oid` bigint(20) NOT NULL   COMMENT '租赁订单id',  
    `message` varchar(60) NOT NULL   COMMENT '后台备注信息（长度未定）',  
    `create_at` bigint(20) NOT NULL   COMMENT '创建时间',  
    `update_at` bigint(20) NOT NULL   COMMENT '更新时间',  
    `create_by` bigint(20) NOT NULL   COMMENT '创建人',  
    `update_by` bigint(20) NOT NULL   COMMENT '更新人',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `rent_orders_log`
-- ----------------------------
-- DROP TABLE IF EXISTS `rent_orders_log`;
CREATE TABLE `rent_orders_log` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `oid` bigint(20) NOT NULL   COMMENT '租赁订单id',  
    `order_status` tinyint(4) NOT NULL   COMMENT '订单状态',  
    `operation_action` tinyint(4) NOT NULL   COMMENT '操作动作',  
    `creater_name` varchar(20) NOT NULL   COMMENT '操作者',  
    `creater_sort` tinyint(4) NOT NULL   COMMENT '操作者身份（1.用户 2.后台管理人员）',  
    `create_at` bigint(20) NOT NULL   COMMENT '创建时间',  
    `update_at` bigint(20) NOT NULL   COMMENT '更新时间',  
    `create_by` bigint(20) NOT NULL   COMMENT '创建人',  
    `update_by` bigint(20) NOT NULL   COMMENT '更新人',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;


-- Table structure for `refund_orders`
-- ----------------------------
-- DROP TABLE IF EXISTS `refund_orders`;
CREATE TABLE `refund_orders` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '自增id',
    `refund_orders_number` varchar(50) NOT NULL   COMMENT '退款订单编号',
    `oid` bigint(20) NOT NULL   COMMENT '关联订单id（保留字段）',
    `associated_order_number` varchar(50) NOT NULL   COMMENT '关联订单编号',
    `rent_fee` decimal(20) NOT NULL   COMMENT '租金',
    `security_fee` decimal(20) NOT NULL   COMMENT '保险',
    `keep_fee` decimal(20) NOT NULL   COMMENT '押金',
    `total_fee` decimal(20) NOT NULL   COMMENT '总金额',
    `pay_method` tinyint(4) NOT NULL   COMMENT '支付方式(10-线下支付  20-微信支付 30-支付宝支付 40-网银支付)',
    `pay_account` varchar(100) NOT NULL   COMMENT '支付账号',
    `create_at` bigint(20) NOT NULL   COMMENT '创建时间',
    `update_at` bigint(20) NOT NULL   COMMENT '更新时间',
    `create_by` bigint(20) NOT NULL   COMMENT '创建人',
    `update_by` bigint(20) NOT NULL   COMMENT '更新人',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;



