/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.xqlease.common.util.ali.pay;

import com.ptteng.xqlease.common.util.ali.MD5;
import com.ptteng.xqlease.common.util.ali.RSA;
import com.ptteng.xqlease.common.util.ali.pay.AlipayCore;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class AlipaySubmit {
    public static final String CODING = "utf-8";
    private static final String ALIPAY_GATEWAY_NEW = "https://mapi.alipay.com/gateway.do?";

    public static String buildRequestMysign(String sign_type, String key, String private_key, Map<String, String> sPara) {
        String prestr = AlipayCore.createLinkString(sPara);
        String mysign = "";
        if (sign_type.equals("MD5")) {
            mysign = MD5.sign(prestr, key, CODING);
        }
        if (sign_type.equals("0001")) {
            mysign = RSA.sign(prestr, private_key, CODING);
        }
        return mysign;
    }

    private static Map<String, String> buildRequestPara(String sign_type, String key, String private_key, Map<String, String> sParaTemp) {
        Map<String, String> sPara = AlipayCore.paraFilter(sParaTemp);
        String mysign = AlipaySubmit.buildRequestMysign(sign_type, key, private_key, sPara);
        sPara.put("sign", mysign);
        sPara.put("sign_type", sign_type);
        return sPara;
    }

    public static String buildRequest(String sign_type, String key, String private_key, Map<String, String> sParaTemp, String strMethod, String strButtonName) {
        Map<String, String> sPara = AlipaySubmit.buildRequestPara(sign_type, key, private_key, sParaTemp);
        ArrayList<String> keys = new ArrayList<String>(sPara.keySet());
        StringBuffer sbHtml = new StringBuffer();
        sbHtml.append("<form id=\"alipaysubmit\" name=\"alipaysubmit\" action=\"https://mapi.alipay.com/gateway.do?_input_charset=utf-8\" method=\"" + strMethod + "\">");
        for (int i = 0; i < keys.size(); ++i) {
            String name = (String)keys.get(i);
            String value = sPara.get(name);
            sbHtml.append("<input type=\"hidden\" name=\"" + name + "\" value=\"" + value + "\"/>");
        }
        sbHtml.append("<input type=\"submit\" value=\"" + strButtonName + "\" style=\"display:none;\"></form>");
        sbHtml.append("<script>document.forms['alipaysubmit'].submit();</script>");
        return sbHtml.toString();
    }

    public static String buildRequest(String sign_type, String key, String private_key, Map<String, String> sParaTemp, String strMethod, String strButtonName, String strParaFileName) {
        Map<String, String> sPara = AlipaySubmit.buildRequestPara(sign_type, key, private_key, sParaTemp);
        ArrayList<String> keys = new ArrayList<String>(sPara.keySet());
        StringBuffer sbHtml = new StringBuffer();
        sbHtml.append("<form id=\"alipaysubmit\" name=\"alipaysubmit\"  enctype=\"multipart/form-data\" action=\"https://mapi.alipay.com/gateway.do?_input_charset=utf-8\" method=\"" + strMethod + "\">");
        for (int i = 0; i < keys.size(); ++i) {
            String name = (String)keys.get(i);
            String value = sPara.get(name);
            sbHtml.append("<input type=\"hidden\" name=\"" + name + "\" value=\"" + value + "\"/>");
        }
        sbHtml.append("<input type=\"file\" name=\"" + strParaFileName + "\" />");
        sbHtml.append("<input type=\"submit\" value=\"" + strButtonName + "\" style=\"display:none;\"></form>");
        return sbHtml.toString();
    }

    public static String query_timestamp(String partner) throws MalformedURLException, DocumentException, IOException {
        String strUrl = "https://mapi.alipay.com/gateway.do?service=query_timestamp&partner=" + partner + "&_input_charset" + CODING;
        StringBuffer result = new StringBuffer();
        SAXReader reader = new SAXReader();
        Document doc = reader.read(new URL(strUrl).openStream());
        List nodeList = doc.selectNodes("//alipay/*");
        for (Node node : nodeList) {
            if (!node.getName().equals("is_success") || !node.getText().equals("T")) continue;
            List nodeList1 = doc.selectNodes("//response/timestamp/*");
            for (Node node1 : nodeList1) {
                result.append(node1.getText());
            }
        }
        return result.toString();
    }
}

