/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.xqlease.common.util.ali.pay;

import com.ptteng.xqlease.common.util.ali.MD5;
import com.ptteng.xqlease.common.util.ali.RSA;
import com.ptteng.xqlease.common.util.ali.pay.AlipayCore;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;

public class AlipayNotify {
    public static final String CODING = "utf-8";

    public static boolean verifyReturn(String sign_type, String key, String ali_public_key, Map<String, String> params) {
        boolean isSign;
        String sign = "";
        if (params.get("sign") != null) {
            sign = params.get("sign");
        }
        return isSign = AlipayNotify.getSignVeryfy(sign_type, key, ali_public_key, params, sign, true);
    }

    public static boolean verifyNotify(String partner, String verify_url, String sign_type, String key, String private_key, String ali_public_key, Map<String, String> params) throws Exception {
        boolean isSign;
        if (sign_type.equals("0001")) {
            params = AlipayNotify.decrypt(params, private_key);
        }
        String responseTxt = "true";
        try {
            Document document = DocumentHelper.parseText((String)params.get("notify_data"));
            String notify_id = document.selectSingleNode("//notify/notify_id").getText();
            responseTxt = AlipayNotify.verifyResponse(partner, verify_url, notify_id);
        }
        catch (Exception e) {
            responseTxt = e.toString();
        }
        String sign = "";
        if (params.get("sign") != null) {
            sign = params.get("sign");
        }
        return (isSign = AlipayNotify.getSignVeryfy(sign_type, key, ali_public_key, params, sign, false)) && responseTxt.equals("true");
    }

    public static Map<String, String> decrypt(Map<String, String> inputPara, String private_key) throws Exception {
        inputPara.put("notify_data", RSA.decrypt(inputPara.get("notify_data"), private_key, CODING));
        return inputPara;
    }

    private static boolean getSignVeryfy(String sign_type, String key, String ali_public_key, Map<String, String> Params, String sign, boolean isSort) {
        Map<String, String> sParaNew = AlipayCore.paraFilter(Params);
        String preSignStr = "";
        preSignStr = isSort ? AlipayCore.createLinkString(sParaNew) : AlipayCore.createLinkStringNoSort(sParaNew);
        boolean isSign = false;
        if (sign_type.equals("MD5")) {
            isSign = MD5.verify(preSignStr, sign, key, CODING);
        }
        if (sign_type.equals("0001")) {
            isSign = RSA.verify(preSignStr, sign, ali_public_key, CODING);
        }
        return isSign;
    }

    private static String verifyResponse(String partner, String verify_url, String notify_id) {
        String veryfy_url = verify_url + "&partner=" + partner + "&notify_id=" + notify_id;
        return AlipayNotify.checkUrl(veryfy_url);
    }

    private static String checkUrl(String urlvalue) {
        String inputLine = "";
        try {
            URL url = new URL(urlvalue);
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
            inputLine = in.readLine().toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            inputLine = "";
        }
        return inputLine;
    }
}

