/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.xqlease.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.xqlease.common.model.Topic;
import com.ptteng.xqlease.common.service.TopicService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TopicServiceImpl
extends BaseDaoServiceImpl
implements TopicService {
    private static final Log log = LogFactory.getLog(TopicServiceImpl.class);

    public Long insert(Topic topic) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + topic));
        if (topic == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        topic.setCreateAt(Long.valueOf(currentTimeMillis));
        topic.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)topic);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + topic));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Topic> insertList(List<Topic> topicList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (topicList == null ? "null" : Integer.valueOf(topicList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(topicList)) {
            return new ArrayList<Topic>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Topic topic : topicList) {
            topic.setCreateAt(Long.valueOf(currentTimeMillis));
            topic.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(topicList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + topicList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Topic.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Topic topic) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (topic == null ? "null" : topic.getId())));
        boolean result = false;
        if (topic == null) {
            return true;
        }
        topic.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)topic);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + topic));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + topic));
        }
        return result;
    }

    public boolean updateList(List<Topic> topicList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (topicList == null ? "null" : Integer.valueOf(topicList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(topicList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Topic topic : topicList) {
            topic.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(topicList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + topicList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + topicList.size()));
        return result;
    }

    public Topic getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Topic topic = null;
        if (id == null) {
            return topic;
        }
        try {
            topic = (Topic)this.dao.get(Topic.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return topic;
    }

    public List<Topic> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List topic = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Topic>();
        }
        try {
            topic = this.dao.getList(Topic.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (topic == null ? "null" : Integer.valueOf(topic.size()))));
        return topic;
    }

    public Long getTopicIdByTopicName(String topicName) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by topicName  : " + topicName));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getTopicIdByTopicName", new Object[]{topicName});
        }
        catch (DaoException e) {
            log.error((Object)(" get id  wrong by topicName  : " + topicName));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + (id == null ? "null" : id)));
        }
        return id;
    }

    public List<Long> getTopicIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getTopicIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countTopicIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getTopicIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getTopicIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }

    public List<Long> getTopicIdsByShelfStatus(Integer shelfStatus, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by shelfStatus,start,limit  : " + shelfStatus + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getTopicIdsByShelfStatus", new Object[]{shelfStatus}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by shelfStatus,start,limit)  : " + shelfStatus + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getTopicIdsOrderByShelfStatusAndSortAndUpdateAt(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getTopicIdsOrderByShelfStatusAndSortAndUpdateAt", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }
}

