/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.xqlease.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.xqlease.common.model.TopicGoods;
import com.ptteng.xqlease.common.service.TopicGoodsService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TopicGoodsServiceImpl
extends BaseDaoServiceImpl
implements TopicGoodsService {
    private static final Log log = LogFactory.getLog(TopicGoodsServiceImpl.class);

    public Long insert(TopicGoods topicGoods) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + topicGoods));
        if (topicGoods == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        topicGoods.setCreateAt(Long.valueOf(currentTimeMillis));
        topicGoods.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)topicGoods);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + topicGoods));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<TopicGoods> insertList(List<TopicGoods> topicGoodsList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (topicGoodsList == null ? "null" : Integer.valueOf(topicGoodsList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(topicGoodsList)) {
            return new ArrayList<TopicGoods>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (TopicGoods topicGoods : topicGoodsList) {
            topicGoods.setCreateAt(Long.valueOf(currentTimeMillis));
            topicGoods.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(topicGoodsList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + topicGoodsList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(TopicGoods.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(TopicGoods topicGoods) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (topicGoods == null ? "null" : topicGoods.getId())));
        boolean result = false;
        if (topicGoods == null) {
            return true;
        }
        topicGoods.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)topicGoods);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + topicGoods));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + topicGoods));
        }
        return result;
    }

    public boolean updateList(List<TopicGoods> topicGoodsList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (topicGoodsList == null ? "null" : Integer.valueOf(topicGoodsList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(topicGoodsList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (TopicGoods topicGoods : topicGoodsList) {
            topicGoods.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(topicGoodsList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + topicGoodsList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + topicGoodsList.size()));
        return result;
    }

    public TopicGoods getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        TopicGoods topicGoods = null;
        if (id == null) {
            return topicGoods;
        }
        try {
            topicGoods = (TopicGoods)this.dao.get(TopicGoods.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return topicGoods;
    }

    public List<TopicGoods> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List topicGoods = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<TopicGoods>();
        }
        try {
            topicGoods = this.dao.getList(TopicGoods.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (topicGoods == null ? "null" : Integer.valueOf(topicGoods.size()))));
        return topicGoods;
    }

    public List<Long> getTopicGoodsIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getTopicGoodsIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countTopicGoodsIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getTopicGoodsIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getTopicGoodsIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }

    public List<Long> getTopicGoodsIdsByTopicId(Long topicId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by topicId,start,limit  : " + topicId + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getTopicGoodsIdsByTopicId", new Object[]{topicId}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by topicId,start,limit)  : " + topicId + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countTopicGoodsIdsByTopicId(Long topicId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by topicId  : " + topicId));
        }
        Integer count = null;
        try {
            count = this.dao.count("getTopicGoodsIdsByTopicId", new Object[]{topicId});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by topicId)  : " + topicId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getTopicGoodsIdsByShelfStatus(Integer shelfStatus, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by shelfStatus,start,limit  : " + shelfStatus + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getTopicGoodsIdsByShelfStatus", new Object[]{shelfStatus}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by shelfStatus,start,limit)  : " + shelfStatus + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getTopicGoodsIdsByTopicIdAndShelfStatus(Long topicId, Integer shelfStatus, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by topicId,shelfStatus,start,limit  : " + topicId + " , " + shelfStatus + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getTopicGoodsIdsByTopicIdAndShelfStatus", new Object[]{topicId, shelfStatus}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by topicId,shelfStatus,start,limit)  : " + topicId + " , " + shelfStatus + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countTopicGoodsIdsByShelfStatusAndGoodsId(Integer shelfStatus, Long goodsId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by shelfStatus,goodsId  : " + shelfStatus + " , " + goodsId));
        }
        Integer count = null;
        try {
            count = this.dao.count("getTopicGoodsIdsByShelfStatusAndGoodsId", new Object[]{shelfStatus, goodsId});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by shelfStatus,goodsId)  : " + shelfStatus + " , " + goodsId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }
}

