/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.xqlease.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.xqlease.common.model.Ticket;
import com.ptteng.xqlease.common.service.TicketService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TicketServiceImpl
extends BaseDaoServiceImpl
implements TicketService {
    private static final Log log = LogFactory.getLog(TicketServiceImpl.class);

    public Long insert(Ticket ticket) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + ticket));
        if (ticket == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        ticket.setCreateAt(Long.valueOf(currentTimeMillis));
        ticket.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)ticket);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + ticket));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Ticket> insertList(List<Ticket> ticketList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (ticketList == null ? "null" : Integer.valueOf(ticketList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(ticketList)) {
            return new ArrayList<Ticket>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Ticket ticket : ticketList) {
            ticket.setCreateAt(Long.valueOf(currentTimeMillis));
            ticket.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(ticketList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + ticketList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Ticket.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Ticket ticket) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (ticket == null ? "null" : ticket.getId())));
        boolean result = false;
        if (ticket == null) {
            return true;
        }
        ticket.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)ticket);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + ticket));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + ticket));
        }
        return result;
    }

    public boolean updateList(List<Ticket> ticketList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (ticketList == null ? "null" : Integer.valueOf(ticketList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(ticketList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Ticket ticket : ticketList) {
            ticket.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(ticketList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + ticketList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + ticketList.size()));
        return result;
    }

    public Ticket getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Ticket ticket = null;
        if (id == null) {
            return ticket;
        }
        try {
            ticket = (Ticket)this.dao.get(Ticket.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return ticket;
    }

    public List<Ticket> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List ticket = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Ticket>();
        }
        try {
            ticket = this.dao.getList(Ticket.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (ticket == null ? "null" : Integer.valueOf(ticket.size()))));
        return ticket;
    }

    public List<Long> getTicketIdsByUidAndTicketStatusOrderByUpdateAt(Long uid, Integer ticketStatus, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by uid,ticketStatus,start,limit  : " + uid + " , " + ticketStatus + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getTicketIdsByUidAndTicketStatusOrderByUpdateAt", new Object[]{uid, ticketStatus}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by uid,ticketStatus,start,limit)  : " + uid + " , " + ticketStatus + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getTicketIdsByUidOrderByUpdateAt(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by uid,start,limit  : " + uid + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getTicketIdsByUidOrderByUpdateAt", new Object[]{uid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by uid,start,limit)  : " + uid + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countTicketIdsByUidAndTicketStatusOrderByUpdateAt(Long uid, Integer ticketStatus) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by uid,ticketStatus  : " + uid + " , " + ticketStatus));
        }
        Integer count = null;
        try {
            count = this.dao.count("getTicketIdsByUidAndTicketStatusOrderByUpdateAt", new Object[]{uid, ticketStatus});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by uid,ticketStatus)  : " + uid + " , " + ticketStatus));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countTicketIdsByUidOrderByUpdateAt(Long uid) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by uid  : " + uid));
        }
        Integer count = null;
        try {
            count = this.dao.count("getTicketIdsByUidOrderByUpdateAt", new Object[]{uid});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by uid)  : " + uid));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getTicketIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getTicketIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countTicketIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getTicketIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getTicketIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

