/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.xqlease.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.xqlease.common.model.Stock;
import com.ptteng.xqlease.common.service.StockService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StockServiceImpl
extends BaseDaoServiceImpl
implements StockService {
    private static final Log log = LogFactory.getLog(StockServiceImpl.class);

    public Long insert(Stock stock) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + stock));
        if (stock == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        stock.setCreateAt(Long.valueOf(currentTimeMillis));
        stock.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)stock);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + stock));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Stock> insertList(List<Stock> stockList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (stockList == null ? "null" : Integer.valueOf(stockList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(stockList)) {
            return new ArrayList<Stock>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Stock stock : stockList) {
            stock.setCreateAt(Long.valueOf(currentTimeMillis));
            stock.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(stockList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + stockList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Stock.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Stock stock) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (stock == null ? "null" : stock.getId())));
        boolean result = false;
        if (stock == null) {
            return true;
        }
        stock.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)stock);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + stock));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + stock));
        }
        return result;
    }

    public boolean updateList(List<Stock> stockList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (stockList == null ? "null" : Integer.valueOf(stockList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(stockList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Stock stock : stockList) {
            stock.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(stockList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + stockList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + stockList.size()));
        return result;
    }

    public Stock getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Stock stock = null;
        if (id == null) {
            return stock;
        }
        try {
            stock = (Stock)this.dao.get(Stock.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return stock;
    }

    public List<Stock> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List stock = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Stock>();
        }
        try {
            stock = this.dao.getList(Stock.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (stock == null ? "null" : Integer.valueOf(stock.size()))));
        return stock;
    }

    public List<Long> getStockIdsByGoodsName(String goodsName, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by goodsName,start,limit  : " + goodsName + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getStockIdsByGoodsName", new Object[]{goodsName}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by goodsName,start,limit)  : " + goodsName + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getStockIdsBySku(String sku, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by sku,start,limit  : " + sku + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getStockIdsBySku", new Object[]{sku}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by sku,start,limit)  : " + sku + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getStockIdsByOperateType(String operateType, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by operateType,start,limit  : " + operateType + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getStockIdsByOperateType", new Object[]{operateType}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by operateType,start,limit)  : " + operateType + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countStockIdsByGoodsName(String goodsName) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by goodsName  : " + goodsName));
        }
        Integer count = null;
        try {
            count = this.dao.count("getStockIdsByGoodsName", new Object[]{goodsName});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by goodsName)  : " + goodsName));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countStockIdsBySku(String sku) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by sku  : " + sku));
        }
        Integer count = null;
        try {
            count = this.dao.count("getStockIdsBySku", new Object[]{sku});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by sku)  : " + sku));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countStockIdsByOperateType(String operateType) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by operateType  : " + operateType));
        }
        Integer count = null;
        try {
            count = this.dao.count("getStockIdsByOperateType", new Object[]{operateType});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by operateType)  : " + operateType));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getStockIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getStockIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countStockIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getStockIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getStockIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

