/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.xqlease.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.xqlease.common.model.ShoppingCart;
import com.ptteng.xqlease.common.service.ShoppingCartService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ShoppingCartServiceImpl
extends BaseDaoServiceImpl
implements ShoppingCartService {
    private static final Log log = LogFactory.getLog(ShoppingCartServiceImpl.class);

    public Long insert(ShoppingCart shoppingCart) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + shoppingCart));
        if (shoppingCart == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        shoppingCart.setCreateAt(Long.valueOf(currentTimeMillis));
        shoppingCart.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)shoppingCart);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + shoppingCart));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<ShoppingCart> insertList(List<ShoppingCart> shoppingCartList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (shoppingCartList == null ? "null" : Integer.valueOf(shoppingCartList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(shoppingCartList)) {
            return new ArrayList<ShoppingCart>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (ShoppingCart shoppingCart : shoppingCartList) {
            shoppingCart.setCreateAt(Long.valueOf(currentTimeMillis));
            shoppingCart.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(shoppingCartList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + shoppingCartList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(ShoppingCart.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(ShoppingCart shoppingCart) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (shoppingCart == null ? "null" : shoppingCart.getId())));
        boolean result = false;
        if (shoppingCart == null) {
            return true;
        }
        shoppingCart.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)shoppingCart);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + shoppingCart));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + shoppingCart));
        }
        return result;
    }

    public boolean updateList(List<ShoppingCart> shoppingCartList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (shoppingCartList == null ? "null" : Integer.valueOf(shoppingCartList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(shoppingCartList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (ShoppingCart shoppingCart : shoppingCartList) {
            shoppingCart.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(shoppingCartList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + shoppingCartList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + shoppingCartList.size()));
        return result;
    }

    public ShoppingCart getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        ShoppingCart shoppingCart = null;
        if (id == null) {
            return shoppingCart;
        }
        try {
            shoppingCart = (ShoppingCart)this.dao.get(ShoppingCart.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return shoppingCart;
    }

    public List<ShoppingCart> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List shoppingCart = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<ShoppingCart>();
        }
        try {
            shoppingCart = this.dao.getList(ShoppingCart.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (shoppingCart == null ? "null" : Integer.valueOf(shoppingCart.size()))));
        return shoppingCart;
    }

    public List<Long> getShoppingCartIdsByUid(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by uid,start,limit  : " + uid + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getShoppingCartIdsByUid", new Object[]{uid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by uid,start,limit)  : " + uid + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countShoppingCartIdsByUid(Long uid) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by uid  : " + uid));
        }
        Integer count = null;
        try {
            count = this.dao.count("getShoppingCartIdsByUid", new Object[]{uid});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by uid)  : " + uid));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getShoppingCartIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getShoppingCartIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countShoppingCartIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getShoppingCartIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getShoppingCartIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

