/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.xqlease.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.xqlease.common.model.SaledOrders;
import com.ptteng.xqlease.common.service.SaledOrdersService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SaledOrdersServiceImpl
extends BaseDaoServiceImpl
implements SaledOrdersService {
    private static final Log log = LogFactory.getLog(SaledOrdersServiceImpl.class);

    public Long insert(SaledOrders saledOrders) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + saledOrders));
        if (saledOrders == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        saledOrders.setCreateAt(Long.valueOf(currentTimeMillis));
        saledOrders.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)saledOrders);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + saledOrders));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<SaledOrders> insertList(List<SaledOrders> saledOrdersList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (saledOrdersList == null ? "null" : Integer.valueOf(saledOrdersList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(saledOrdersList)) {
            return new ArrayList<SaledOrders>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (SaledOrders saledOrders : saledOrdersList) {
            saledOrders.setCreateAt(Long.valueOf(currentTimeMillis));
            saledOrders.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(saledOrdersList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + saledOrdersList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(SaledOrders.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(SaledOrders saledOrders) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (saledOrders == null ? "null" : saledOrders.getId())));
        boolean result = false;
        if (saledOrders == null) {
            return true;
        }
        saledOrders.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)saledOrders);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + saledOrders));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + saledOrders));
        }
        return result;
    }

    public boolean updateList(List<SaledOrders> saledOrdersList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (saledOrdersList == null ? "null" : Integer.valueOf(saledOrdersList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(saledOrdersList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (SaledOrders saledOrders : saledOrdersList) {
            saledOrders.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(saledOrdersList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + saledOrdersList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + saledOrdersList.size()));
        return result;
    }

    public SaledOrders getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        SaledOrders saledOrders = null;
        if (id == null) {
            return saledOrders;
        }
        try {
            saledOrders = (SaledOrders)this.dao.get(SaledOrders.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return saledOrders;
    }

    public List<SaledOrders> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List saledOrders = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<SaledOrders>();
        }
        try {
            saledOrders = this.dao.getList(SaledOrders.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (saledOrders == null ? "null" : Integer.valueOf(saledOrders.size()))));
        return saledOrders;
    }

    public List<Long> getSaledOrdersIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getSaledOrdersIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countSaledOrdersIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getSaledOrdersIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getSaledOrdersIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }

    public Integer countSaledOrdersIdsBySaledOrdersTypeAndSaledOrdersStatus(Integer saledOrdersType, Integer saledOrdersStatus) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by saledOrdersType,saledOrdersStatus  : " + saledOrdersType + " , " + saledOrdersStatus));
        }
        Integer count = null;
        try {
            count = this.dao.count("getSaledOrdersIdsBySaledOrdersTypeAndSaledOrdersStatus", new Object[]{saledOrdersType, saledOrdersStatus});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by saledOrdersType,saledOrdersStatus)  : " + saledOrdersType + " , " + saledOrdersStatus));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countSaledOrdersIdsByUidAndSaledOrdersType(Long uid, Integer saledOrdersType) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by uid,saledOrdersType  : " + uid + " , " + saledOrdersType));
        }
        Integer count = null;
        try {
            count = this.dao.count("getSaledOrdersIdsByUidAndSaledOrdersType", new Object[]{uid, saledOrdersType});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by uid,saledOrdersType)  : " + uid + " , " + saledOrdersType));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }
}

