/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.xqlease.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.xqlease.common.model.RentOrders;
import com.ptteng.xqlease.common.service.RentOrdersService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RentOrdersServiceImpl
extends BaseDaoServiceImpl
implements RentOrdersService {
    private static final Log log = LogFactory.getLog(RentOrdersServiceImpl.class);

    public Long insert(RentOrders rentOrders) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + rentOrders));
        if (rentOrders == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        rentOrders.setCreateAt(Long.valueOf(currentTimeMillis));
        rentOrders.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)rentOrders);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + rentOrders));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<RentOrders> insertList(List<RentOrders> rentOrdersList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (rentOrdersList == null ? "null" : Integer.valueOf(rentOrdersList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(rentOrdersList)) {
            return new ArrayList<RentOrders>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (RentOrders rentOrders : rentOrdersList) {
            rentOrders.setCreateAt(Long.valueOf(currentTimeMillis));
            rentOrders.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(rentOrdersList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + rentOrdersList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(RentOrders.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(RentOrders rentOrders) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (rentOrders == null ? "null" : rentOrders.getId())));
        boolean result = false;
        if (rentOrders == null) {
            return true;
        }
        rentOrders.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)rentOrders);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + rentOrders));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + rentOrders));
        }
        return result;
    }

    public boolean updateList(List<RentOrders> rentOrdersList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (rentOrdersList == null ? "null" : Integer.valueOf(rentOrdersList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(rentOrdersList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (RentOrders rentOrders : rentOrdersList) {
            rentOrders.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(rentOrdersList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + rentOrdersList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + rentOrdersList.size()));
        return result;
    }

    public RentOrders getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        RentOrders rentOrders = null;
        if (id == null) {
            return rentOrders;
        }
        try {
            rentOrders = (RentOrders)this.dao.get(RentOrders.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return rentOrders;
    }

    public List<RentOrders> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List rentOrders = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<RentOrders>();
        }
        try {
            rentOrders = this.dao.getList(RentOrders.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (rentOrders == null ? "null" : Integer.valueOf(rentOrders.size()))));
        return rentOrders;
    }

    public Long getRentOrdersIdByOrdersNumber(String ordersNumber) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by ordersNumber  : " + ordersNumber));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getRentOrdersIdByOrdersNumber", new Object[]{ordersNumber});
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by ordersNumber )  : " + ordersNumber));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + (id == null ? "null" : id)));
        }
        return id;
    }

    public List<Long> getRentOrdersIdsByUid(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by uid,start,limit  : " + uid + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getRentOrdersIdsByUid", new Object[]{uid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by uid,start,limit)  : " + uid + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countRentOrdersIdsByOrdersNumber(Long ordersNumber) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by ordersNumber  : " + ordersNumber));
        }
        Integer count = null;
        try {
            count = this.dao.count("getRentOrdersIdsByOrdersNumber", new Object[]{ordersNumber});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by ordersNumber)  : " + ordersNumber));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countRentOrdersIdsByUid(Long uid) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by uid  : " + uid));
        }
        Integer count = null;
        try {
            count = this.dao.count("getRentOrdersIdsByUid", new Object[]{uid});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by uid)  : " + uid));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getRentOrdersIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getRentOrdersIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countRentOrdersIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getRentOrdersIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getRentOrdersIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }

    public Integer countRentOrdersIdsByOrdersStatus(Integer ordersStatus) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by ordersStatus  : " + ordersStatus));
        }
        Integer count = null;
        try {
            count = this.dao.count("getRentOrdersIdsByOrdersStatus", new Object[]{ordersStatus});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by ordersStatus)  : " + ordersStatus));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countRentOrdersIdsByOrdersStatusAndPayMethod(Integer ordersStatus, Integer payMethod) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by ordersStatus,payMethod  : " + ordersStatus + " , " + payMethod));
        }
        Integer count = null;
        try {
            count = this.dao.count("getRentOrdersIdsByOrdersStatusAndPayMethod", new Object[]{ordersStatus, payMethod});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by ordersStatus,payMethod)  : " + ordersStatus + " , " + payMethod));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getRentOrdersByParentOrdersNumberAndOrderStatus(String parentOrdersNumber, Integer ordersStatus, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by parentNumber , ordersStatus, start,limit  ================== " + parentOrdersNumber + " , " + ordersStatus + " , " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getRentOrdersByParentOrdersNumberAndOrderStatus", new Object[]{parentOrdersNumber, ordersStatus}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids   by parentNumber , ordersStatus, start,limit  ================== " + parentOrdersNumber + " , " + ordersStatus + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getRentOrdersByParentNumber(String parentOrdersNumber, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by parentNumber , start,limit  ================== " + parentOrdersNumber + " , " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getRentOrdersByParentNumber", new Object[]{parentOrdersNumber}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids   by parentOrdersNumber , start,limit  ================== " + parentOrdersNumber + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countRentOrdersIdsByUidAndOrdersType(Long uid, Integer ordersType) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by uid,ordersType  : " + uid + " , " + ordersType));
        }
        Integer count = null;
        try {
            count = this.dao.count("getRentOrdersIdsByUidAndOrdersType", new Object[]{uid, ordersType});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by uid,ordersType)  : " + uid + " , " + ordersType));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }
}

