/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.xqlease.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.xqlease.common.model.RentOrdersLog;
import com.ptteng.xqlease.common.service.RentOrdersLogService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RentOrdersLogServiceImpl
extends BaseDaoServiceImpl
implements RentOrdersLogService {
    private static final Log log = LogFactory.getLog(RentOrdersLogServiceImpl.class);

    public Long insert(RentOrdersLog rentOrdersLog) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + rentOrdersLog));
        if (rentOrdersLog == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        rentOrdersLog.setCreateAt(Long.valueOf(currentTimeMillis));
        rentOrdersLog.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)rentOrdersLog);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + rentOrdersLog));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<RentOrdersLog> insertList(List<RentOrdersLog> rentOrdersLogList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (rentOrdersLogList == null ? "null" : Integer.valueOf(rentOrdersLogList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(rentOrdersLogList)) {
            return new ArrayList<RentOrdersLog>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (RentOrdersLog rentOrdersLog : rentOrdersLogList) {
            rentOrdersLog.setCreateAt(Long.valueOf(currentTimeMillis));
            rentOrdersLog.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(rentOrdersLogList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + rentOrdersLogList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(RentOrdersLog.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(RentOrdersLog rentOrdersLog) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (rentOrdersLog == null ? "null" : rentOrdersLog.getId())));
        boolean result = false;
        if (rentOrdersLog == null) {
            return true;
        }
        rentOrdersLog.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)rentOrdersLog);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + rentOrdersLog));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + rentOrdersLog));
        }
        return result;
    }

    public boolean updateList(List<RentOrdersLog> rentOrdersLogList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (rentOrdersLogList == null ? "null" : Integer.valueOf(rentOrdersLogList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(rentOrdersLogList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (RentOrdersLog rentOrdersLog : rentOrdersLogList) {
            rentOrdersLog.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(rentOrdersLogList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + rentOrdersLogList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + rentOrdersLogList.size()));
        return result;
    }

    public RentOrdersLog getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        RentOrdersLog rentOrdersLog = null;
        if (id == null) {
            return rentOrdersLog;
        }
        try {
            rentOrdersLog = (RentOrdersLog)this.dao.get(RentOrdersLog.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return rentOrdersLog;
    }

    public List<RentOrdersLog> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List rentOrdersLog = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<RentOrdersLog>();
        }
        try {
            rentOrdersLog = this.dao.getList(RentOrdersLog.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (rentOrdersLog == null ? "null" : Integer.valueOf(rentOrdersLog.size()))));
        return rentOrdersLog;
    }

    public List<Long> getRentOrdersLogIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getRentOrdersLogIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countRentOrdersLogIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getRentOrdersLogIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getRentOrdersLogIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }

    public List<Long> getRentOrderLogsIdsByOid(Long oid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by oid, start,limit  ================== " + oid + " , " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getRentOrderLogsIdsByOid", new Object[]{oid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by oid , start,limit)  : " + oid + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }
}

