/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.xqlease.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.xqlease.common.model.RefundOrders;
import com.ptteng.xqlease.common.service.RefundOrdersService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RefundOrdersServiceImpl
extends BaseDaoServiceImpl
implements RefundOrdersService {
    private static final Log log = LogFactory.getLog(RefundOrdersServiceImpl.class);

    public Long insert(RefundOrders refundOrders) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + refundOrders));
        if (refundOrders == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        refundOrders.setCreateAt(Long.valueOf(currentTimeMillis));
        refundOrders.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)refundOrders);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + refundOrders));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<RefundOrders> insertList(List<RefundOrders> refundOrdersList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (refundOrdersList == null ? "null" : Integer.valueOf(refundOrdersList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(refundOrdersList)) {
            return new ArrayList<RefundOrders>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (RefundOrders refundOrders : refundOrdersList) {
            refundOrders.setCreateAt(Long.valueOf(currentTimeMillis));
            refundOrders.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(refundOrdersList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + refundOrdersList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(RefundOrders.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(RefundOrders refundOrders) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (refundOrders == null ? "null" : refundOrders.getId())));
        boolean result = false;
        if (refundOrders == null) {
            return true;
        }
        refundOrders.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)refundOrders);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + refundOrders));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + refundOrders));
        }
        return result;
    }

    public boolean updateList(List<RefundOrders> refundOrdersList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (refundOrdersList == null ? "null" : Integer.valueOf(refundOrdersList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(refundOrdersList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (RefundOrders refundOrders : refundOrdersList) {
            refundOrders.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(refundOrdersList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + refundOrdersList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + refundOrdersList.size()));
        return result;
    }

    public RefundOrders getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        RefundOrders refundOrders = null;
        if (id == null) {
            return refundOrders;
        }
        try {
            refundOrders = (RefundOrders)this.dao.get(RefundOrders.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return refundOrders;
    }

    public List<RefundOrders> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List refundOrders = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<RefundOrders>();
        }
        try {
            refundOrders = this.dao.getList(RefundOrders.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (refundOrders == null ? "null" : Integer.valueOf(refundOrders.size()))));
        return refundOrders;
    }

    public Long getRefundOrdersIdByRefundOrdersNumber(String refundOrdersNumber) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by refundOrdersNumber  : " + refundOrdersNumber));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getRefundOrdersIdByRefundOrdersNumber", new Object[]{refundOrdersNumber});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by refundOrdersNumber  : " + refundOrdersNumber));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public List<Long> getRefundOrdersIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getRefundOrdersIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countRefundOrdersIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getRefundOrdersIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getRefundOrdersIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }

    public List<Long> getRefundOrdersIdsByUidAndOrdersStatus(Long uid, Integer ordersStatus, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by uid,ordersStatus,start,limit  : " + uid + " , " + ordersStatus + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getRefundOrdersIdsByUidAndOrdersStatus", new Object[]{uid, ordersStatus}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by uid,ordersStatus,start,limit)  : " + uid + " , " + ordersStatus + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }
}

