/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.xqlease.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.xqlease.common.model.Orders;
import com.ptteng.xqlease.common.service.OrderService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OrderServiceImpl
extends BaseDaoServiceImpl
implements OrderService {
    private static final Log log = LogFactory.getLog(OrderServiceImpl.class);

    public Long insert(Orders orders) throws ServiceException, ServiceDaoException {
        log.info((Object)("orders insert data : " + orders));
        if (orders == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        orders.setCreateAt(Long.valueOf(currentTimeMillis));
        orders.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)orders);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + orders));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        return result;
    }

    public List<Orders> insertList(List<Orders> ordersList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (ordersList == null ? "null" : Integer.valueOf(ordersList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(ordersList)) {
            return new ArrayList<Orders>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Orders orders : ordersList) {
            orders.setCreateAt(Long.valueOf(currentTimeMillis));
            orders.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(ordersList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + ordersList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Orders.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Orders orders) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (orders == null ? "null" : orders.getId())));
        boolean result = false;
        if (orders == null) {
            return true;
        }
        orders.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)orders);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + orders));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + orders));
        }
        return result;
    }

    public boolean updateList(List<Orders> ordersList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (ordersList == null ? "null" : Integer.valueOf(ordersList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(ordersList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Orders orders : ordersList) {
            orders.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(ordersList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + ordersList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + ordersList.size()));
        return result;
    }

    public Orders getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Orders orders = null;
        if (id == null) {
            return orders;
        }
        try {
            orders = (Orders)this.dao.get(Orders.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return orders;
    }

    public List<Orders> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List orders = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Orders>();
        }
        try {
            orders = this.dao.getList(Orders.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (orders == null ? "null" : Integer.valueOf(orders.size()))));
        return orders;
    }

    public List<Long> getOrderIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getOrderIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countOrderIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getOrderIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getOrderIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

