/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.xqlease.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.xqlease.common.model.GoodsSort;
import com.ptteng.xqlease.common.service.GoodsSortService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GoodsSortServiceImpl
extends BaseDaoServiceImpl
implements GoodsSortService {
    private static final Log log = LogFactory.getLog(GoodsSortServiceImpl.class);

    public Long insert(GoodsSort goodsSort) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + goodsSort));
        if (goodsSort == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        goodsSort.setCreateAt(Long.valueOf(currentTimeMillis));
        goodsSort.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)goodsSort);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + goodsSort));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<GoodsSort> insertList(List<GoodsSort> goodsSortList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (goodsSortList == null ? "null" : Integer.valueOf(goodsSortList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(goodsSortList)) {
            return new ArrayList<GoodsSort>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (GoodsSort goodsSort : goodsSortList) {
            goodsSort.setCreateAt(Long.valueOf(currentTimeMillis));
            goodsSort.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(goodsSortList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + goodsSortList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(GoodsSort.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(GoodsSort goodsSort) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (goodsSort == null ? "null" : goodsSort.getId())));
        boolean result = false;
        if (goodsSort == null) {
            return true;
        }
        goodsSort.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)goodsSort);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + goodsSort));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + goodsSort));
        }
        return result;
    }

    public boolean updateList(List<GoodsSort> goodsSortList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (goodsSortList == null ? "null" : Integer.valueOf(goodsSortList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(goodsSortList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (GoodsSort goodsSort : goodsSortList) {
            goodsSort.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(goodsSortList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + goodsSortList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + goodsSortList.size()));
        return result;
    }

    public GoodsSort getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        GoodsSort goodsSort = null;
        if (id == null) {
            return goodsSort;
        }
        try {
            goodsSort = (GoodsSort)this.dao.get(GoodsSort.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return goodsSort;
    }

    public List<GoodsSort> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List goodsSort = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<GoodsSort>();
        }
        try {
            goodsSort = this.dao.getList(GoodsSort.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (goodsSort == null ? "null" : Integer.valueOf(goodsSort.size()))));
        return goodsSort;
    }

    public List<Long> getGoodsSortIdsBySortLevelOrderBySort(Integer sortLevel, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by sortLevel,start,limit  : " + sortLevel + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getGoodsSortIdsBySortLevelOrderBySort", new Object[]{sortLevel}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by sortLevel,start,limit)  : " + sortLevel + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getGoodsSortIdsByShelfStatusOrderBySort(Integer shelfStatus, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by shelfStatus,start,limit  : " + shelfStatus + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getGoodsSortIdsByShelfStatusOrderBySort", new Object[]{shelfStatus}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by shelfStatus,start,limit)  : " + shelfStatus + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Long getGoodsSortIdBySortNameOrderBySort(String sortName) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by sortName  : " + sortName));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getGoodsSortIdBySortNameOrderBySort", new Object[]{sortName});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by sortName  : " + sortName));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public Integer countGoodsSortIdsBySortLevelOrderBySort(Integer sortLevel) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by sortLevel  : " + sortLevel));
        }
        Integer count = null;
        try {
            count = this.dao.count("getGoodsSortIdsBySortLevelOrderBySort", new Object[]{sortLevel});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by sortLevel)  : " + sortLevel));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countGoodsSortIdsByShelfStatusOrderBySort(Integer shelfStatus) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by shelfStatus  : " + shelfStatus));
        }
        Integer count = null;
        try {
            count = this.dao.count("getGoodsSortIdsByShelfStatusOrderBySort", new Object[]{shelfStatus});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by shelfStatus)  : " + shelfStatus));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countGoodsSortIdsBySortNameOrderBySort(String sortName) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by sortName  : " + sortName));
        }
        Integer count = null;
        try {
            count = this.dao.count("getGoodsSortIdsBySortNameOrderBySort", new Object[]{sortName});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by sortName)  : " + sortName));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getGoodsSortIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getGoodsSortIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countGoodsSortIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getGoodsSortIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getGoodsSortIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }

    public List<Long> getGoodsSortIdsByFatherIdOrderBySort(Long fatherId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by fatherId,start,limit  : " + fatherId + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getGoodsSortIdsByFatherIdOrderBySort", new Object[]{fatherId}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by fatherId,start,limit)  : " + fatherId + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }
}

