/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.xqlease.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.xqlease.common.model.GoodsSku;
import com.ptteng.xqlease.common.service.GoodsSkuService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GoodsSkuServiceImpl
extends BaseDaoServiceImpl
implements GoodsSkuService {
    private static final Log log = LogFactory.getLog(GoodsSkuServiceImpl.class);

    public Long insert(GoodsSku goodsSku) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + goodsSku));
        if (goodsSku == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        goodsSku.setCreateAt(Long.valueOf(currentTimeMillis));
        goodsSku.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)goodsSku);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + goodsSku));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<GoodsSku> insertList(List<GoodsSku> goodsSkuList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (goodsSkuList == null ? "null" : Integer.valueOf(goodsSkuList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(goodsSkuList)) {
            return new ArrayList<GoodsSku>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (GoodsSku goodsSku : goodsSkuList) {
            goodsSku.setCreateAt(Long.valueOf(currentTimeMillis));
            goodsSku.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(goodsSkuList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + goodsSkuList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(GoodsSku.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(GoodsSku goodsSku) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (goodsSku == null ? "null" : goodsSku.getId())));
        boolean result = false;
        if (goodsSku == null) {
            return true;
        }
        goodsSku.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)goodsSku);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + goodsSku));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + goodsSku));
        }
        return result;
    }

    public boolean updateList(List<GoodsSku> goodsSkuList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (goodsSkuList == null ? "null" : Integer.valueOf(goodsSkuList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(goodsSkuList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (GoodsSku goodsSku : goodsSkuList) {
            goodsSku.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(goodsSkuList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + goodsSkuList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + goodsSkuList.size()));
        return result;
    }

    public GoodsSku getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        GoodsSku goodsSku = null;
        if (id == null) {
            return goodsSku;
        }
        try {
            goodsSku = (GoodsSku)this.dao.get(GoodsSku.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return goodsSku;
    }

    public List<GoodsSku> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List goodsSku = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<GoodsSku>();
        }
        try {
            goodsSku = this.dao.getList(GoodsSku.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (goodsSku == null ? "null" : Integer.valueOf(goodsSku.size()))));
        return goodsSku;
    }

    public List<Long> getGoodsSkuIdsByGoodsIdOrderBySort(Long goodsId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by goodsId,start,limit  : " + goodsId + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getGoodsSkuIdsByGoodsIdOrderBySort", new Object[]{goodsId}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by goodsId,start,limit)  : " + goodsId + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countGoodsSkuIdsByGoodsId(Long goodsId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by goodsId  : " + goodsId));
        }
        Integer count = null;
        try {
            count = this.dao.count("getGoodsSkuIdsByGoodsId", new Object[]{goodsId});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by goodsId)  : " + goodsId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getGoodsSkuIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getGoodsSkuIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countGoodsSkuIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getGoodsSkuIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getGoodsSkuIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }

    public Long getGoodsSkuIdBySkuNumber(String skuNumber) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by skuNumber  : " + skuNumber));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getGoodsSkuIdBySkuNumber", new Object[]{skuNumber});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by skuNumber  : " + skuNumber));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public List<Long> getGoodsSkuIdsByGoodsIdAndShelfStatusOrderBySortAndUpdateAt(Long goodsId, Integer shelfStatus, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by goodsId,shelfStatus,start,limit  : " + goodsId + " , " + shelfStatus + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getGoodsSkuIdsByGoodsIdAndShelfStatusOrderBySortAndUpdateAt", new Object[]{goodsId, shelfStatus}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by goodsId,shelfStatus,start,limit)  : " + goodsId + " , " + shelfStatus + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getGoodsSkuIdsByShelfStatusAndGoodsId(Integer shelfStatus, Long goodsId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by shelfStatus,goodsId,start,limit  : " + shelfStatus + " , " + goodsId + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getGoodsSkuIdsByShelfStatusAndGoodsId", new Object[]{shelfStatus, goodsId}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by shelfStatus,goodsId,start,limit)  : " + shelfStatus + " , " + goodsId + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countGoodsSkuIdsByShelfStatusAndGoodsId(Integer shelfStatus, Long goodsId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by shelfStatus,goodsId  : " + shelfStatus + " , " + goodsId));
        }
        Integer count = null;
        try {
            count = this.dao.count("getGoodsSkuIdsByShelfStatusAndGoodsId", new Object[]{shelfStatus, goodsId});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by shelfStatus,goodsId)  : " + shelfStatus + " , " + goodsId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }
}

