/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.xqlease.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.xqlease.common.model.GoodsSecurity;
import com.ptteng.xqlease.common.service.GoodsSecurityService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GoodsSecurityServiceImpl
extends BaseDaoServiceImpl
implements GoodsSecurityService {
    private static final Log log = LogFactory.getLog(GoodsSecurityServiceImpl.class);

    public Long insert(GoodsSecurity goodsSecurity) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + goodsSecurity));
        if (goodsSecurity == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        goodsSecurity.setCreateAt(Long.valueOf(currentTimeMillis));
        goodsSecurity.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)goodsSecurity);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + goodsSecurity));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<GoodsSecurity> insertList(List<GoodsSecurity> goodsSecurityList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (goodsSecurityList == null ? "null" : Integer.valueOf(goodsSecurityList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(goodsSecurityList)) {
            return new ArrayList<GoodsSecurity>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (GoodsSecurity goodsSecurity : goodsSecurityList) {
            goodsSecurity.setCreateAt(Long.valueOf(currentTimeMillis));
            goodsSecurity.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(goodsSecurityList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + goodsSecurityList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(GoodsSecurity.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(GoodsSecurity goodsSecurity) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (goodsSecurity == null ? "null" : goodsSecurity.getId())));
        boolean result = false;
        if (goodsSecurity == null) {
            return true;
        }
        goodsSecurity.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)goodsSecurity);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + goodsSecurity));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + goodsSecurity));
        }
        return result;
    }

    public boolean updateList(List<GoodsSecurity> goodsSecurityList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (goodsSecurityList == null ? "null" : Integer.valueOf(goodsSecurityList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(goodsSecurityList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (GoodsSecurity goodsSecurity : goodsSecurityList) {
            goodsSecurity.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(goodsSecurityList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + goodsSecurityList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + goodsSecurityList.size()));
        return result;
    }

    public GoodsSecurity getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        GoodsSecurity goodsSecurity = null;
        if (id == null) {
            return goodsSecurity;
        }
        try {
            goodsSecurity = (GoodsSecurity)this.dao.get(GoodsSecurity.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return goodsSecurity;
    }

    public List<GoodsSecurity> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List goodsSecurity = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<GoodsSecurity>();
        }
        try {
            goodsSecurity = this.dao.getList(GoodsSecurity.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (goodsSecurity == null ? "null" : Integer.valueOf(goodsSecurity.size()))));
        return goodsSecurity;
    }

    public List<Long> getGoodsSecurityIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getGoodsSecurityIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countGoodsSecurityIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getGoodsSecurityIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getGoodsSecurityIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

