/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.xqlease.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.xqlease.common.model.Brand;
import com.ptteng.xqlease.common.service.BrandService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BrandServiceImpl
extends BaseDaoServiceImpl
implements BrandService {
    private static final Log log = LogFactory.getLog(BrandServiceImpl.class);

    public Long insert(Brand brand) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + brand));
        if (brand == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        brand.setCreateAt(Long.valueOf(currentTimeMillis));
        brand.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)brand);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + brand));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Brand> insertList(List<Brand> brandList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (brandList == null ? "null" : Integer.valueOf(brandList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(brandList)) {
            return new ArrayList<Brand>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Brand brand : brandList) {
            brand.setCreateAt(Long.valueOf(currentTimeMillis));
            brand.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(brandList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + brandList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Brand.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Brand brand) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (brand == null ? "null" : brand.getId())));
        boolean result = false;
        if (brand == null) {
            return true;
        }
        brand.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)brand);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + brand));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + brand));
        }
        return result;
    }

    public boolean updateList(List<Brand> brandList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (brandList == null ? "null" : Integer.valueOf(brandList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(brandList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Brand brand : brandList) {
            brand.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(brandList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + brandList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + brandList.size()));
        return result;
    }

    public Brand getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Brand brand = null;
        if (id == null) {
            return brand;
        }
        try {
            brand = (Brand)this.dao.get(Brand.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return brand;
    }

    public List<Brand> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List brand = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Brand>();
        }
        try {
            brand = this.dao.getList(Brand.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (brand == null ? "null" : Integer.valueOf(brand.size()))));
        return brand;
    }

    public List<Long> getBrandIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getBrandIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countBrandIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getBrandIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getBrandIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }

    public Long getBrandIdByBrandName(String brandName) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + brandName));
        Long id = null;
        if (brandName == null) {
            return id;
        }
        try {
            id = (Long)this.dao.getMapping("getBrandIdByBrandName", new Object[]{brandName});
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return id;
    }

    public List<Long> getBrandIdsByShelfStatusOrderBySortAndUpdateAt(Integer shelfStatus, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get getBrandIdsByShelfStatusOrderBySortAndUpdateAt  by shelfStatus  start,limit  ================== " + shelfStatus + " , " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getBrandIdsByShelfStatusOrderBySortAndUpdateAt", new Object[]{shelfStatus}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by shelfStatus start,limit)  : " + shelfStatus + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }
}

